/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ModIdentification {
    public static Function<String, Optional<Info>> supplier;
    public static Function<ItemStack, String> itemStackSupplier;
    private static final Map<String, Info> CONTAINER_CACHE;
    private static final Info MC_MOD_INFO;
    private static final Info COMMON_MOD_INFO;

    public static Info getModInfo(String namespace) {
        return CONTAINER_CACHE.computeIfAbsent(namespace, s -> supplier.apply(namespace).orElse(new Info((String)s, (String)s)));
    }

    public static Info getModInfo(ResourceLocation id) {
        return ModIdentification.getModInfo(id.func_110624_b());
    }

    public static Info getModInfo(Block block) {
        return ModIdentification.getModInfo(Registry.field_212618_g.func_177774_c((Object)block));
    }

    public static Info getModInfo(ItemStack stack) {
        return ModIdentification.getModInfo(itemStackSupplier.apply(stack));
    }

    public static Info getModInfo(Item item) {
        return ModIdentification.getModInfo(Registry.field_212630_s.func_177774_c((Object)item));
    }

    public static Info getModInfo(Entity entity) {
        ResourceLocation id = Registry.field_212629_r.func_177774_c((Object)entity.func_200600_R());
        return ModIdentification.getModInfo(id == null ? new ResourceLocation("nope") : id);
    }

    static {
        CONTAINER_CACHE = Maps.newHashMap();
        MC_MOD_INFO = new Info("minecraft", "Minecraft");
        COMMON_MOD_INFO = new Info("c", "Common");
        CONTAINER_CACHE.put(MC_MOD_INFO.getId(), MC_MOD_INFO);
        CONTAINER_CACHE.put(COMMON_MOD_INFO.getId(), COMMON_MOD_INFO);
    }

    public static class Info {
        private final String id;
        private final String name;

        public Info(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

