/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.binding.compat.VanillaBooleanOptionBinding;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawChunkRenderBackend;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.text.TranslationTextComponent;

public class SodiumGameOptionPages {
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.renderDistance").getString()).setTooltip(new TranslationTextComponent("sodium.options.view_distance.tooltip").getString()).setControl(option -> new SliderControl((Option<Integer>)option, 2, 32, 1, ControlValueFormatter.quantity(new TranslationTextComponent("options.chunks").getString()))).setBinding((options, value) -> {
            options.field_151451_c = value;
        }, options -> options.field_151451_c).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.gamma").getString()).setTooltip(new TranslationTextComponent("sodium.options.brightness.tooltip").getString()).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> {
            opts.field_74333_Y = (double)value.intValue() * 0.01;
        }, opts -> (int)(opts.field_74333_Y / 0.01)).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(new TranslationTextComponent("sodium.options.clouds.name").getString()).setTooltip(new TranslationTextComponent("sodium.options.clouds.tooltip").getString()).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            Framebuffer framebuffer;
            opts.quality.enableClouds = value;
            if (Minecraft.func_238218_y_() && (framebuffer = Minecraft.func_71410_x().field_71438_f.func_239232_u_()) != null) {
                framebuffer.func_216493_b(Minecraft.field_142025_a);
            }
        }, opts -> opts.quality.enableClouds).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.guiScale").getString()).setTooltip(new TranslationTextComponent("sodium.options.gui_scale.tooltip").getString()).setControl(option -> new SliderControl((Option<Integer>)option, 0, Minecraft.func_71410_x().func_228018_at_().func_216521_a(0, Minecraft.func_71410_x().func_211821_e()), 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.field_74335_Z = value;
            Minecraft client = Minecraft.func_71410_x();
            client.func_213226_a();
        }, opts -> opts.field_74335_Z).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.fullscreen").getString()).setTooltip(new TranslationTextComponent("sodium.options.fullscreen.tooltip").getString()).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74353_u = value;
            Minecraft client = Minecraft.func_71410_x();
            MainWindow window = client.func_228018_at_();
            if (window != null && window.func_198113_j() != opts.field_74353_u) {
                window.func_198077_g();
                opts.field_74353_u = window.func_198113_j();
            }
        }, opts -> opts.field_74353_u).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.vsync").getString()).setTooltip(new TranslationTextComponent("sodium.options.v_sync.tooltip").getString()).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding(AbstractOption.field_216682_F)).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.framerateLimit").getString()).setTooltip(new TranslationTextComponent("sodium.options.fps_limit.tooltip").getString()).setControl(option -> new SliderControl((Option<Integer>)option, 5, 260, 5, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.field_74350_i = value;
            Minecraft.func_71410_x().func_228018_at_().func_216526_a(value.intValue());
        }, opts -> opts.field_74350_i).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.viewBobbing").getString()).setTooltip(new TranslationTextComponent("sodium.options.view_bobbing.tooltip").getString()).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding(AbstractOption.field_216692_P)).build()).add(OptionImpl.createBuilder(AttackIndicatorStatus.class, vanillaOpts).setName(new TranslationTextComponent("options.attackIndicator").getString()).setTooltip(new TranslationTextComponent("sodium.options.attack_indicator.tooltip").getString()).setControl(opts -> new CyclingControl<AttackIndicatorStatus>((Option<AttackIndicatorStatus>)opts, AttackIndicatorStatus.class, new String[]{new TranslationTextComponent("options.off").getString(), new TranslationTextComponent("options.attack.crosshair").getString(), new TranslationTextComponent("options.attack.hotbar").getString()})).setBinding((opts, value) -> {
            opts.field_186716_M = value;
        }, opts -> opts.field_186716_M).build()).build());
        return new OptionPage(new TranslationTextComponent("stat.generalButton").getString(), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage quality() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(GraphicsFanciness.class, vanillaOpts).setName(new TranslationTextComponent("options.graphics").getString()).setTooltip(new TranslationTextComponent("sodium.options.graphics_quality.tooltip").getString()).setControl(option -> new CyclingControl<GraphicsFanciness>((Option<GraphicsFanciness>)option, GraphicsFanciness.class, new String[]{new TranslationTextComponent("options.graphics.fast").getString(), new TranslationTextComponent("options.graphics.fancy").getString(), new TranslationTextComponent("options.graphics.fabulous").getString()})).setBinding((opts, value) -> {
            opts.field_238330_f_ = value;
        }, opts -> opts.field_238330_f_).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName(new TranslationTextComponent("options.renderClouds").getString()).setTooltip(new TranslationTextComponent("sodium.options.clouds_quality.tooltip").getString()).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.cloudQuality = value;
        }, opts -> opts.quality.cloudQuality).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName(new TranslationTextComponent("soundCategory.weather").getString()).setTooltip(new TranslationTextComponent("sodium.options.weather_quality.tooltip").getString()).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.weatherQuality = value;
        }, opts -> opts.quality.weatherQuality).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName(new TranslationTextComponent("sodium.options.leaves_quality.name").getString()).setTooltip(new TranslationTextComponent("sodium.options.leaves_quality.tooltip").getString()).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.leavesQuality = value;
        }, opts -> opts.quality.leavesQuality).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(ParticleStatus.class, vanillaOpts).setName(new TranslationTextComponent("options.particles").getString()).setTooltip(new TranslationTextComponent("sodium.options.particle_quality.tooltip").getString()).setControl(opt -> new CyclingControl<ParticleStatus>((Option<ParticleStatus>)opt, ParticleStatus.class, new String[]{new TranslationTextComponent("options.particles.all").getString(), new TranslationTextComponent("options.particles.decreased").getString(), new TranslationTextComponent("options.particles.minimal").getString()})).setBinding((opts, value) -> {
            opts.field_74362_aa = value;
        }, opts -> opts.field_74362_aa).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.LightingQuality.class, sodiumOpts).setName(new TranslationTextComponent("options.ao").getString()).setTooltip(new TranslationTextComponent("sodium.options.smooth_lighting.tooltip").getString()).setControl(option -> new CyclingControl<SodiumGameOptions.LightingQuality>((Option<SodiumGameOptions.LightingQuality>)option, SodiumGameOptions.LightingQuality.class)).setBinding((opts, value) -> {
            opts.quality.smoothLighting = value;
        }, opts -> opts.quality.smoothLighting).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.biomeBlendRadius").getString()).setTooltip(new TranslationTextComponent("sodium.options.biome_blend.tooltip").getString()).setControl(option -> new SliderControl((Option<Integer>)option, 0, 7, 1, ControlValueFormatter.quantityOrDisabled("block(s)", "None"))).setBinding((opts, value) -> {
            opts.field_205217_U = value;
        }, opts -> opts.field_205217_U).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.entityDistanceScaling").getString()).setTooltip(new TranslationTextComponent("sodium.options.entity_distance.tooltip").getString()).setControl(option -> new SliderControl((Option<Integer>)option, 50, 500, 25, ControlValueFormatter.percentage())).setBinding((opts, value) -> {
            opts.field_238329_c_ = (float)value.intValue() / 100.0f;
        }, opts -> Math.round(opts.field_238329_c_ * 100.0f)).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.entityShadows").getString()).setTooltip(new TranslationTextComponent("sodium.options.entity_shadows.tooltip").getString()).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_181151_V = value;
        }, opts -> opts.field_181151_V).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(new TranslationTextComponent("sodium.options.vignette.name").getString()).setTooltip(new TranslationTextComponent("sodium.options.vignette.tooltip").getString()).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableVignette = value;
        }, opts -> opts.quality.enableVignette).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(new TranslationTextComponent("options.mipmapLevels").getString()).setTooltip(new TranslationTextComponent("sodium.options.mipmap_levels.tooltip").getString()).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> {
            opts.field_151442_I = value;
        }, opts -> opts.field_151442_I).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        return new OptionPage(new TranslationTextComponent("sodium.options.pages.quality").getString(), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage advanced() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Use Chunk Multi-Draw").setTooltip("Multi-draw allows multiple chunks to be rendered with fewer draw calls, greatly reducing CPU overhead when rendering the world while also potentially allowing for more efficient GPU utilization. This optimization may cause issues with some graphics drivers, so you should try disabling it if you are experiencing glitches.").setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useChunkMultidraw = value;
        }, opts -> opts.advanced.useChunkMultidraw).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setImpact(OptionImpact.EXTREME).setEnabled(MultidrawChunkRenderBackend.isSupported(SodiumGameOptionPages.sodiumOpts.getData().advanced.ignoreDriverBlacklist)).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Use Vertex Array Objects").setTooltip("Helps to improve performance by moving information about how vertex data should be rendered into the driver, allowing it to better optimize for repeated rendering of the same objects. There is generally no reason to disable this unless you're using incompatible mods.").setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useVertexArrayObjects = value;
        }, opts -> opts.advanced.useVertexArrayObjects).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(new TranslationTextComponent("sodium.options.use_block_face_culling.name").getString()).setTooltip(new TranslationTextComponent("sodium.options.use_block_face_culling.tooltip").getString()).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useBlockFaceCulling = value;
        }, opts -> opts.advanced.useBlockFaceCulling).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Use Compact Vertex Format").setTooltip("If enabled, a more compact vertex format will be used for rendering chunks. This can reduce graphics memory usage and bandwidth requirements significantly, especially for integrated graphics cards, but can cause z-fighting with some resource packs due to how it reduces the precision of position and texture coordinate attributes.").setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useCompactVertexFormat = value;
        }, opts -> opts.advanced.useCompactVertexFormat).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(new TranslationTextComponent("sodium.options.use_fog_occlusion.name").getString()).setTooltip(new TranslationTextComponent("sodium.options.use_fog_occlusion.tooltip").getString()).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useFogOcclusion = value;
        }, opts -> opts.advanced.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(new TranslationTextComponent("sodium.options.use_entity_culling.name").getString()).setTooltip(new TranslationTextComponent("sodium.options.use_entity_culling.tooltip").getString()).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useEntityCulling = value;
        }, opts -> opts.advanced.useEntityCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(new TranslationTextComponent("sodium.options.use_particle_culling.name").getString()).setTooltip(new TranslationTextComponent("sodium.options.use_particle_culling.tooltip").getString()).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useParticleCulling = value;
        }, opts -> opts.advanced.useParticleCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(new TranslationTextComponent("sodium.options.animate_only_visible_textures.name").getString()).setTooltip(new TranslationTextComponent("sodium.options.animate_only_visible_textures.tooltip").getString()).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.advanced.animateOnlyVisibleTextures = value;
        }, opts -> opts.advanced.animateOnlyVisibleTextures).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(new TranslationTextComponent("sodium.options.allow_direct_memory_access.name").getString()).setTooltip(new TranslationTextComponent("sodium.options.allow_direct_memory_access.tooltip").getString()).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.advanced.allowDirectMemoryAccess = value;
        }, opts -> opts.advanced.allowDirectMemoryAccess).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Ignore Driver Blacklist").setTooltip("If enabled, known incompatibilities with your hardware/driver configuration will be ignored, allowing you to enable options that may cause issues with your game. You should generally not touch this option unless you know exactly what you are doing. After changing this option, you must save, close, and then re-open the settings screen.").setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.ignoreDriverBlacklist = value;
        }, opts -> opts.advanced.ignoreDriverBlacklist).build()).build());
        return new OptionPage(new TranslationTextComponent("sodium.options.pages.advanced").getString(), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

