/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.color;

import java.util.function.Function;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class FastCubicSampler {
    private static final double[] DENSITY_CURVE = new double[]{0.0, 1.0, 4.0, 6.0, 4.0, 1.0, 0.0};
    private static final int DIAMETER = 6;

    public static Vector3d sampleColor(Vector3d pos, ColorFetcher colorFetcher, Function<Vector3d, Vector3d> transformer) {
        int intX = MathHelper.func_76128_c((double)pos.func_82615_a());
        int intY = MathHelper.func_76128_c((double)pos.func_82617_b());
        int intZ = MathHelper.func_76128_c((double)pos.func_82616_c());
        int[] values = new int[216];
        for (int x = 0; x < 6; ++x) {
            int blockX = intX - 2 + x;
            for (int y = 0; y < 6; ++y) {
                int blockY = intY - 2 + y;
                for (int z = 0; z < 6; ++z) {
                    int blockZ = intZ - 2 + z;
                    values[FastCubicSampler.index((int)x, (int)y, (int)z)] = colorFetcher.fetch(blockX, blockY, blockZ);
                }
            }
        }
        if (FastCubicSampler.isHomogenousArray(values)) {
            return transformer.apply(Vector3d.func_237487_a_((int)values[0]));
        }
        double deltaX = pos.func_82615_a() - (double)intX;
        double deltaY = pos.func_82617_b() - (double)intY;
        double deltaZ = pos.func_82616_c() - (double)intZ;
        Vector3d sum = Vector3d.field_186680_a;
        double totalFactor = 0.0;
        for (int x = 0; x < 6; ++x) {
            double densityX = MathHelper.func_219803_d((double)deltaX, (double)DENSITY_CURVE[x + 1], (double)DENSITY_CURVE[x]);
            for (int y = 0; y < 6; ++y) {
                double densityY = MathHelper.func_219803_d((double)deltaY, (double)DENSITY_CURVE[y + 1], (double)DENSITY_CURVE[y]);
                for (int z = 0; z < 6; ++z) {
                    double densityZ = MathHelper.func_219803_d((double)deltaZ, (double)DENSITY_CURVE[z + 1], (double)DENSITY_CURVE[z]);
                    double factor = densityX * densityY * densityZ;
                    totalFactor += factor;
                    Vector3d color = transformer.apply(Vector3d.func_237487_a_((int)values[FastCubicSampler.index(x, y, z)]));
                    sum = sum.func_178787_e(color.func_186678_a(factor));
                }
            }
        }
        sum = sum.func_186678_a(1.0 / totalFactor);
        return sum;
    }

    private static int index(int x, int y, int z) {
        return 36 * z + 6 * y + x;
    }

    private static boolean isHomogenousArray(int[] arr) {
        int val = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] == val) continue;
            return false;
        }
        return true;
    }

    public static interface ColorFetcher {
        public int fetch(int var1, int var2, int var3);
    }
}

