/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.buffer_builder.intrinsics;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.DefaultColorVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorU8;
import me.jellysquid.mods.sodium.client.util.math.MatrixUtil;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BufferBuilder.class})
public abstract class MixinBufferBuilder
extends DefaultColorVertexBuilder {
    @Shadow
    private boolean field_227826_s_;

    public void func_227890_a_(MatrixStack.Entry matrices, BakedQuad quad, float[] brightnessTable, float r, float g, float b, int[] light, int overlay, boolean colorize) {
        if (!this.field_227826_s_) {
            super.func_227890_a_(matrices, quad, brightnessTable, r, g, b, light, overlay, colorize);
            return;
        }
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        ModelQuadView quadView = (ModelQuadView)quad;
        Matrix4f modelMatrix = matrices.func_227870_a_();
        Matrix3f normalMatrix = matrices.func_227872_b_();
        int norm = MatrixUtil.computeNormal(normalMatrix, quad.func_178210_d());
        QuadVertexSink drain = VertexDrain.of((IVertexBuilder)this).createSink(VanillaVertexTypes.QUADS);
        drain.ensureCapacity(4);
        for (int i = 0; i < 4; ++i) {
            float fB;
            float fG;
            float fR;
            float x = quadView.getX(i);
            float y = quadView.getY(i);
            float z = quadView.getZ(i);
            float brightness = brightnessTable[i];
            if (colorize) {
                int color = quadView.getColor(i);
                float oR = ColorU8.normalize(ColorABGR.unpackRed(color));
                float oG = ColorU8.normalize(ColorABGR.unpackGreen(color));
                float oB = ColorU8.normalize(ColorABGR.unpackBlue(color));
                fR = oR * brightness * r;
                fG = oG * brightness * g;
                fB = oB * brightness * b;
            } else {
                fR = brightness * r;
                fG = brightness * g;
                fB = brightness * b;
            }
            float u = quadView.getTexU(i);
            float v = quadView.getTexV(i);
            int color = ColorABGR.pack(fR, fG, fB, 1.0f);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            pos.func_229372_a_(modelMatrix);
            drain.writeQuad(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c(), color, u, v, light[i], overlay, norm);
        }
        drain.flush();
    }
}

