/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.chunk_rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.SortedSet;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public abstract class MixinWorldRenderer {
    @Shadow
    @Final
    private RenderTypeBuffers field_228415_m_;
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<DestroyBlockProgress>> field_228407_B_;
    private SodiumWorldRenderer renderer;

    @Redirect(method={"func_72712_a"}, at=@At(value="FIELD", target="Lnet/minecraft/client/GameSettings;field_151451_c:I", ordinal=1))
    private int nullifyBuiltChunkStorage(GameSettings options) {
        return 0;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(Minecraft client, RenderTypeBuffers bufferBuilders, CallbackInfo ci) {
        this.renderer = SodiumWorldRenderer.create();
    }

    @Inject(method={"setWorld"}, at={@At(value="RETURN")})
    private void onWorldChanged(ClientWorld world, CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.setWorld(world);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public int func_184382_g() {
        return this.renderer.getVisibleChunkCount();
    }

    @Overwrite
    public boolean func_184384_n() {
        return this.renderer.isTerrainRenderComplete();
    }

    @Inject(method={"scheduleTerrainUpdate"}, at={@At(value="RETURN")})
    private void onTerrainUpdateScheduled(CallbackInfo ci) {
        this.renderer.scheduleTerrainUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    private void func_228441_a_(RenderType renderLayer, MatrixStack matrixStack, double x, double y, double z) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.drawChunkLayer(renderLayer, matrixStack, x, y, z);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    private void func_228437_a_(ActiveRenderInfo camera, ClippingHelper frustum, boolean hasForcedFrustum, int frame, boolean spectator) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.updateChunks(camera, frustum, hasForcedFrustum, frame, spectator);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public void func_147585_a(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.renderer.scheduleRebuildForBlockArea(minX, minY, minZ, maxX, maxY, maxZ, false);
    }

    @Overwrite
    public void func_215321_a(int x, int y, int z) {
        this.renderer.scheduleRebuildForChunks(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1, false);
    }

    @Overwrite
    private void func_215324_a(BlockPos pos, boolean important) {
        this.renderer.scheduleRebuildForBlockArea(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1, important);
    }

    @Overwrite
    private void func_215319_a(int x, int y, int z, boolean important) {
        this.renderer.scheduleRebuildForChunk(x, y, z, important);
    }

    @Inject(method={"reload"}, at={@At(value="RETURN")})
    private void onReload(CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.reload();
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/render/WorldRenderer;noCullingBlockEntities:Ljava/util/Set;", shift=At.Shift.BEFORE, ordinal=0)})
    private void onRenderTileEntities(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        this.renderer.renderTileEntities(matrices, this.field_228415_m_, this.field_228407_B_, camera, tickDelta);
    }

    @Overwrite
    public String func_72735_c() {
        return this.renderer.getChunksDebugString();
    }
}

