/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.utils.TagUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class ArcRecyclingChecker {
    private final Object2BooleanMap<Item> knownItemValidity = new Object2BooleanOpenHashMap();
    private static final Set<IRecipeType<?>> RECYCLING_RECIPE_TYPES = new HashSet();
    private static final List<Predicate<ItemStack>> RECYCLING_ALLOWED_STACK_SENSITIVE = new ArrayList<Predicate<ItemStack>>();
    private static final List<Predicate<Item>> RECYCLING_ALLOWED = new ArrayList<Predicate<Item>>();
    private static final List<Supplier<Stream<Item>>> RECYCLING_ALLOWED_ENUMERATED = new ArrayList<Supplier<Stream<Item>>>();
    private static final List<Predicate<ItemStack>> INVALID_RECYCLING_OUTPUTS = new ArrayList<Predicate<ItemStack>>();

    public ArcRecyclingChecker() {
        RECYCLING_ALLOWED_ENUMERATED.stream().flatMap(Supplier::get).forEach(i -> this.knownItemValidity.put(i, true));
    }

    public boolean isAllowed(ItemStack stack) {
        if (this.knownItemValidity.computeBooleanIfAbsent((Object)stack.func_77973_b(), i -> RECYCLING_ALLOWED.stream().anyMatch(p -> p.test(i)))) {
            return true;
        }
        for (Predicate<ItemStack> stackSensitive : RECYCLING_ALLOWED_STACK_SENSITIVE) {
            if (!stackSensitive.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static void allowEnumeratedItemsForRecycling(Supplier<Stream<Item>> getAllowedItems) {
        RECYCLING_ALLOWED_ENUMERATED.add(getAllowedItems);
    }

    public static void allowPrefixedTagForRecycling(String prefix) {
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> TagUtils.GET_ITEM_TAG_COLLECTION.get().func_241833_a().entrySet().stream().filter(e -> ((ResourceLocation)e.getKey()).func_110623_a().startsWith(prefix)).map(Map.Entry::getValue).flatMap(t -> t.func_230236_b_().stream()));
    }

    public static void allowItemTagForRecycling(ITag.INamedTag<Item> tag) {
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> {
            ITag<Item> realTag = TagUtils.getItemTag(tag.func_230234_a_());
            return realTag.func_230236_b_().stream();
        });
    }

    public static void allowSimpleItemForRecycling(Predicate<Item> predicate) {
        RECYCLING_ALLOWED.add(predicate);
    }

    public static void allowRecipeTypeForRecycling(IRecipeType<?> recipeType) {
        RECYCLING_RECIPE_TYPES.add(recipeType);
    }

    public static void allowItemForRecycling(Predicate<ItemStack> predicate) {
        RECYCLING_ALLOWED_STACK_SENSITIVE.add(predicate);
    }

    public static void makeItemInvalidRecyclingOutput(Predicate<ItemStack> predicate) {
        INVALID_RECYCLING_OUTPUTS.add(predicate);
    }

    public static Pair<Predicate<IRecipe<?>>, ArcRecyclingChecker> assembleRecyclingFilter() {
        ArcRecyclingChecker checker = new ArcRecyclingChecker();
        return Pair.of(iRecipe -> {
            if (!RECYCLING_RECIPE_TYPES.contains(iRecipe.func_222127_g())) {
                return false;
            }
            return checker.isAllowed(iRecipe.func_77571_b());
        }, (Object)checker);
    }

    public static boolean isValidRecyclingOutput(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (Predicate<ItemStack> predicate : INVALID_RECYCLING_OUTPUTS) {
            if (!predicate.test(stack)) continue;
            return false;
        }
        return true;
    }
}

