/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.excavator;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class MineralMix
extends IESerializableRecipe {
    public static IRecipeType<MineralMix> TYPE;
    public static RegistryObject<IERecipeSerializer<MineralMix>> SERIALIZER;
    public static Map<ResourceLocation, MineralMix> mineralList;
    public final StackWithChance[] outputs;
    public final int weight;
    public final float failChance;
    public final ImmutableSet<RegistryKey<World>> dimensions;
    public final Block background;

    public MineralMix(ResourceLocation id, StackWithChance[] outputs, int weight, float failChance, List<RegistryKey<World>> dimensions, Block background) {
        super(ItemStack.field_190927_a, TYPE, id);
        this.weight = weight;
        this.failChance = failChance;
        this.outputs = outputs;
        this.dimensions = ImmutableSet.copyOf(dimensions);
        this.background = background;
    }

    @Override
    protected IERecipeSerializer<MineralMix> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public String getPlainName() {
        String path = this.func_199560_c().func_110623_a();
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public String getTranslationKey() {
        return "desc.immersiveengineering.info.mineral." + this.getPlainName();
    }

    public ItemStack getRandomOre(Random rand) {
        float r = rand.nextFloat();
        for (StackWithChance o : this.outputs) {
            if (!(o.getChance() >= 0.0f) || !((r -= o.getChance()) < 0.0f)) continue;
            return o.getStack();
        }
        return ItemStack.field_190927_a;
    }

    public boolean validDimension(RegistryKey<World> dim) {
        if (this.dimensions != null && !this.dimensions.isEmpty()) {
            return this.dimensions.contains(dim);
        }
        return true;
    }

    static {
        mineralList = new HashMap<ResourceLocation, MineralMix>();
    }
}

