/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.localhandlers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.ICollisionHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.utils.IElectricDamageSource;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class WireDamageHandler
extends LocalNetworkHandler
implements ICollisionHandler {
    public static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "wire_damage");
    public static final SetRestrictedField<BiFunction<Float, IElectricEquipment.ElectricSource, IElectricDamageSource>> GET_WIRE_DAMAGE = SetRestrictedField.common();
    private static final double KNOCKBACK_PER_DAMAGE = 10.0;

    public WireDamageHandler(LocalWireNetwork net, GlobalWireNetwork global) {
        super(net, global);
    }

    @Override
    public void onCollided(LivingEntity e, BlockPos pos, WireCollisionData.CollisionInfo info) {
        boolean collides;
        WireType wType = info.conn.type;
        if (!(wType instanceof IShockingWire)) {
            return;
        }
        EnergyTransferHandler energyHandler = this.getEnergyHandler();
        if (energyHandler == null) {
            return;
        }
        IShockingWire shockWire = (IShockingWire)((Object)wType);
        double extra = shockWire.getDamageRadius();
        AxisAlignedBB eAabb = e.func_174813_aQ();
        AxisAlignedBB includingExtra = eAabb.func_186662_g(extra).func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        boolean bl = collides = includingExtra.func_72318_a(info.intersectA) || includingExtra.func_72318_a(info.intersectB);
        if (!collides && !includingExtra.func_216365_b(info.intersectA, info.intersectB).isPresent()) {
            return;
        }
        ConnectionPoint target = info.conn.getEndA();
        List<SourceData> available = this.getAvailableEnergy(energyHandler, target);
        if (available.isEmpty()) {
            return;
        }
        int totalAvailable = 0;
        for (SourceData source : available) {
            totalAvailable = (int)((double)totalAvailable + (double)source.amountAvailable * (1.0 - ((SourceData)source).pathToSource.loss));
        }
        float maxPossibleDamage = shockWire.getDamageAmount((Entity)e, info.conn, totalAvailable = Math.min(totalAvailable, shockWire.getTransferRate()));
        if (maxPossibleDamage <= 0.0f) {
            return;
        }
        IElectricDamageSource dmg = GET_WIRE_DAMAGE.getValue().apply(Float.valueOf(maxPossibleDamage), shockWire.getElectricSource());
        if (!dmg.apply((Entity)e)) {
            return;
        }
        float actualDamage = dmg.getDamage();
        Vector3d v = e.func_70040_Z();
        ApiUtils.knockbackNoSource(e, (double)actualDamage / 10.0, v.field_72450_a, v.field_72449_c);
        double factor = actualDamage / maxPossibleDamage;
        Object2DoubleMap<Connection> transferred = energyHandler.getTransferredNextTick();
        for (SourceData source : available) {
            double energyFromSource = (double)source.amountAvailable * factor;
            source.source.extractEnergy(MathHelper.func_76143_f((double)energyFromSource));
            for (Connection c : ((SourceData)source).pathToSource.conns) {
                transferred.mergeDouble((Object)c, energyFromSource, Double::sum);
            }
        }
    }

    private List<SourceData> getAvailableEnergy(EnergyTransferHandler energyHandler, ConnectionPoint target) {
        ArrayList<SourceData> ret = new ArrayList<SourceData>();
        Map<ConnectionPoint, EnergyTransferHandler.Path> paths = null;
        for (Map.Entry<ConnectionPoint, EnergyTransferHandler.EnergyConnector> c : energyHandler.getSources().entrySet()) {
            EnergyTransferHandler.Path path;
            int energy = c.getValue().getAvailableEnergy();
            if (energy <= 0) continue;
            if (paths == null) {
                paths = energyHandler.getPathsFromSource(target);
            }
            if ((path = paths.get(c.getKey())) == null) continue;
            ret.add(new SourceData(energy, path, c.getValue(), c.getKey()));
        }
        return ret;
    }

    private EnergyTransferHandler getEnergyHandler() {
        return this.localNet.getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class);
    }

    @Override
    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        return this;
    }

    @Override
    public void onConnectorLoaded(ConnectionPoint p, IImmersiveConnectable iic) {
    }

    @Override
    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
    }

    @Override
    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
    }

    @Override
    public void onConnectionAdded(Connection c) {
    }

    @Override
    public void onConnectionRemoved(Connection c) {
    }

    public static interface IShockingWire
    extends EnergyTransferHandler.IEnergyWire {
        public double getDamageRadius();

        public IElectricEquipment.ElectricSource getElectricSource();

        default public float getDamageAmount(Entity e, Connection c, int energy) {
            return 0.0f;
        }
    }

    private static class SourceData {
        private final int amountAvailable;
        private final EnergyTransferHandler.Path pathToSource;
        private final EnergyTransferHandler.EnergyConnector source;
        private final ConnectionPoint point;

        public SourceData(int amount, EnergyTransferHandler.Path path, EnergyTransferHandler.EnergyConnector source, ConnectionPoint point) {
            this.amountAvailable = amount;
            this.pathToSource = path;
            this.source = source;
            this.point = point;
        }
    }
}

