/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;

@OnlyIn(value=Dist.CLIENT)
public class IEShaderLayerCompositeTexture
extends Texture {
    private final ResourceLocation canvasTexture;
    private final ShaderLayer[] layers;

    public IEShaderLayerCompositeTexture(ResourceLocation canvasTexture, ShaderLayer[] layers) {
        this.canvasTexture = canvasTexture;
        this.layers = layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195413_a(@Nonnull IResourceManager resourceManager) {
        this.func_147631_c();
        IResource iresource = null;
        NativeImage finalTexture = null;
        NativeImage originalImage = null;
        try {
            iresource = resourceManager.func_199002_a(this.canvasTexture);
            originalImage = NativeImage.func_195713_a((InputStream)iresource.func_199027_b());
            int canvasWidth = originalImage.func_195702_a();
            int canvasHeight = originalImage.func_195714_b();
            finalTexture = new NativeImage(canvasWidth, canvasHeight, true);
            for (int layer = 0; layer < 17 && layer < this.layers.length; ++layer) {
                IResource iresource1 = null;
                try {
                    String texPath = this.layers[layer].getTexture().func_110623_a();
                    if (!texPath.startsWith("textures/")) {
                        texPath = "textures/" + texPath;
                    }
                    if (!texPath.endsWith(".png")) {
                        texPath = texPath + ".png";
                    }
                    String texture = this.layers[layer].getTexture().func_110624_b() + ":" + texPath;
                    Vector4f colour = this.layers[layer].getColor();
                    iresource1 = resourceManager.func_199002_a(new ResourceLocation(texture));
                    NativeImage texureImage = NativeImage.func_195713_a((InputStream)iresource1.func_199027_b());
                    float[] fArray = new float[]{colour.func_195910_a(), colour.func_195913_b(), colour.func_195914_c(), colour.func_195915_d()};
                    float[] mod = fArray;
                    if ((double)mod[3] < 0.2) {
                        mod[3] = mod[3] * 2.5f;
                    }
                    IntFunction<Integer> uInterpolate = uIn -> uIn;
                    IntFunction<Integer> vInterpolate = vIn -> vIn;
                    int bufImg2Size = Math.min(texureImage.func_195702_a(), texureImage.func_195714_b());
                    int uMin = 0;
                    int vMin = 0;
                    int uMax = canvasWidth;
                    int vMax = canvasHeight;
                    double[] texBounds = this.layers[layer].getTextureBounds();
                    if (texBounds != null) {
                        double uOffset = texBounds[0] * (double)canvasWidth;
                        double vOffset = texBounds[1] * (double)canvasHeight;
                        double uScale = (double)bufImg2Size / ((texBounds[2] - texBounds[0]) * (double)canvasWidth);
                        double vScale = (double)bufImg2Size / ((texBounds[3] - texBounds[1]) * (double)canvasHeight);
                        uInterpolate = uIn -> (int)Math.round(((double)uIn - uOffset) * uScale);
                        vInterpolate = vIn -> (int)Math.round(((double)vIn - vOffset) * vScale);
                        uMin = (int)uOffset;
                        vMin = (int)vOffset;
                        uMax = (int)(texBounds[2] * (double)canvasWidth);
                        vMax = (int)(texBounds[3] * (double)canvasHeight);
                    }
                    try {
                        for (int v = vMin; v < vMax; ++v) {
                            for (int u = uMin; u < uMax; ++u) {
                                int color;
                                int interU = uInterpolate.apply(u) % bufImg2Size;
                                int interV = vInterpolate.apply(v) % bufImg2Size;
                                int iRGB = texureImage.func_195709_a(interU, interV);
                                float[] rgb = new float[]{(float)(iRGB & 0xFF) / 255.0f, (float)(iRGB >> 8 & 0xFF) / 255.0f, (float)(iRGB >> 16 & 0xFF) / 255.0f, (float)(iRGB >> 24 & 0xFF) / 255.0f};
                                if ((iRGB & 0xFF000000) == 0) continue;
                                int iNoise = originalImage.func_195709_a(u, v);
                                float[] noise = new float[]{(float)(iNoise & 0xFF) / 255.0f, (float)(iNoise >> 8 & 0xFF) / 255.0f, (float)(iNoise >> 16 & 0xFF) / 255.0f, (float)(iNoise >> 24 & 0xFF) / 255.0f};
                                for (int m = 0; m < 4; ++m) {
                                    rgb[m] = rgb[m] * mod[m] * noise[m];
                                }
                                int[] irgb = new int[]{(int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f), (int)(rgb[3] * 255.0f)};
                                int i2 = irgb[0] + (irgb[1] << 8) + (irgb[2] << 16) + (irgb[3] << 24);
                                int pre = finalTexture.func_195709_a(u, v) >> 24 & 0xFF;
                                this.blendPixel(finalTexture, u, v, i2);
                                int post = finalTexture.func_195709_a(u, v);
                                if (pre == 0) {
                                    color = irgb[3] << 24 | post & 0xFFFFFF;
                                    finalTexture.func_195700_a(u, v, color);
                                    continue;
                                }
                                if ((post >> 24 & 0xFF) >= pre) continue;
                                color = pre << 24 | post & 0xFFFFFF;
                                finalTexture.func_195700_a(u, v, color);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(iresource1);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)iresource1);
            }
            TextureUtil.func_225681_a_((int)this.func_110552_b(), (int)0, (int)finalTexture.func_195702_a(), (int)finalTexture.func_195714_b());
            finalTexture.func_227789_a_(0, 0, 0, 0, 0, finalTexture.func_195702_a(), finalTexture.func_195714_b(), false, false, false, false);
        }
        catch (IOException ioexception) {
            try {
                IELogger.error("Couldn't load layered image", ioexception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(iresource);
                if (originalImage != null) {
                    originalImage.close();
                }
                if (finalTexture != null) {
                    finalTexture.close();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)iresource);
            if (originalImage != null) {
                originalImage.close();
            }
            if (finalTexture != null) {
                finalTexture.close();
            }
        }
        IOUtils.closeQuietly((Closeable)iresource);
        if (originalImage != null) {
            originalImage.close();
        }
        if (finalTexture != null) {
            finalTexture.close();
        }
    }

    private void blendPixel(NativeImage image, int xIn, int yIn, int colIn) {
        int existing = image.func_195709_a(xIn, yIn);
        float alphaIn = (float)NativeImage.func_227786_a_((int)colIn) / 255.0f;
        float blueIn = (float)NativeImage.func_227795_d_((int)colIn) / 255.0f;
        float greenIn = (float)NativeImage.func_227793_c_((int)colIn) / 255.0f;
        float redIn = (float)NativeImage.func_227791_b_((int)colIn) / 255.0f;
        float alphaOld = (float)NativeImage.func_227786_a_((int)existing) / 255.0f;
        float blueOld = (float)NativeImage.func_227795_d_((int)existing) / 255.0f;
        float greenOld = (float)NativeImage.func_227793_c_((int)existing) / 255.0f;
        float redOld = (float)NativeImage.func_227791_b_((int)existing) / 255.0f;
        float oldMixFactor = 1.0f - alphaIn;
        float alphaOut = alphaIn * alphaIn + alphaOld * oldMixFactor;
        float blueOut = blueIn * alphaIn + blueOld * oldMixFactor;
        float greenOut = greenIn * alphaIn + greenOld * oldMixFactor;
        float redOut = redIn * alphaIn + redOld * oldMixFactor;
        if (alphaOut > 1.0f) {
            alphaOut = 1.0f;
        }
        if (blueOut > 1.0f) {
            blueOut = 1.0f;
        }
        if (greenOut > 1.0f) {
            greenOut = 1.0f;
        }
        if (redOut > 1.0f) {
            redOut = 1.0f;
        }
        int redOutInt = (int)(alphaOut * 255.0f);
        int blueOutInt = (int)(blueOut * 255.0f);
        int greenOutInt = (int)(greenOut * 255.0f);
        int alphaOutInt = (int)(redOut * 255.0f);
        image.func_195700_a(xIn, yIn, NativeImage.func_227787_a_((int)redOutInt, (int)blueOutInt, (int)greenOutInt, (int)alphaOutInt));
    }
}

