/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableTileEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public abstract class AbstractTransformerTileEntity
extends ImmersiveConnectableTileEntity
implements IEBlockInterfaces.IStateBasedDirectional {
    protected static final int RIGHT_INDEX = 0;
    protected static final int LEFT_INDEX = 1;
    protected WireType leftType;
    protected WireType rightType;
    protected Set<String> acceptableLowerWires = ImmutableSet.of((Object)"LV");

    public AbstractTransformerTileEntity(TileEntityType<? extends ImmersiveConnectableTileEntity> type) {
        super(type);
    }

    protected boolean canAttach(WireType toAttach, @Nullable WireType atConn, @Nullable WireType other) {
        boolean isOtherHigher;
        if (atConn != null) {
            return false;
        }
        String higherCat = this.getHigherWiretype();
        String attachCat = toAttach.getCategory();
        if (other == null) {
            return higherCat.equals(attachCat) || this.acceptableLowerWires.contains(attachCat);
        }
        boolean isHigher = higherCat.equals(toAttach.getCategory());
        if (isHigher ^ (isOtherHigher = higherCat.equals(other.getCategory()))) {
            if (isHigher) {
                return true;
            }
            return this.acceptableLowerWires.contains(attachCat);
        }
        return false;
    }

    public String getHigherWiretype() {
        return "MV";
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.field_174879_c, 0), (Object)new ConnectionPoint(this.field_174879_c, 1));
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        return ImmutableList.of((Object)new Connection(this.field_174879_c, 1, 0));
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        return this.getConnectionOffset(con, con.getEndFor(this.field_174879_c).getIndex() == 0);
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        WireType type;
        WireType wireType = type = connection != null ? connection.type : null;
        if (type == null) {
            this.rightType = null;
            this.leftType = null;
        } else {
            switch (attachedPoint.getIndex()) {
                case 1: {
                    this.leftType = null;
                    break;
                }
                case 0: {
                    this.rightType = null;
                }
            }
        }
        this.updateMirrorState();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        switch (target.getIndex()) {
            case 1: {
                this.leftType = cableType;
                break;
            }
            case 0: {
                this.rightType = cableType;
            }
        }
        this.updateMirrorState();
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        switch (target.getIndex()) {
            case 1: {
                return this.canAttach(cableType, this.leftType, this.rightType);
            }
            case 0: {
                return this.canAttach(cableType, this.rightType, this.leftType);
            }
        }
        return false;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.leftType != null) {
            nbt.func_74778_a("leftType", this.leftType.getUniqueName());
        }
        if (this.rightType != null) {
            nbt.func_74778_a("rightType", this.rightType.getUniqueName());
        }
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.leftType = nbt.func_74764_b("leftType") ? WireUtils.getWireTypeFromNBT(nbt, "leftType") : null;
        this.rightType = nbt.func_74764_b("rightType") ? WireUtils.getWireTypeFromNBT(nbt, "rightType") : null;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    protected abstract Vector3d getConnectionOffset(Connection var1, boolean var2);

    protected void updateMirrorState() {
    }
}

