/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class MetalPressPackingRecipes {
    public static Map<ResourceLocation, ICraftingRecipe> CRAFTING_RECIPE_MAP;
    private static final HashMap<ComparableItemStack, RecipeDelegate> UNPACKING_CACHE;

    public static MetalPressRecipe get2x2PackingContainer() {
        return new MetalPressPackingRecipe(new ResourceLocation("immersiveengineering", "metalpress/packing2x2"), IEItems.Molds.moldPacking4, 2);
    }

    public static MetalPressRecipe get3x3PackingContainer() {
        return new MetalPressPackingRecipe(new ResourceLocation("immersiveengineering", "metalpress/packing3x3"), IEItems.Molds.moldPacking9, 3);
    }

    public static MetalPressRecipe getUnpackingContainer() {
        return new MetalPressContainerRecipe(new ResourceLocation("immersiveengineering", "metalpress/unpacking"), IEItems.Molds.moldUnpacking){

            @Override
            protected MetalPressRecipe getRecipeFunction(ItemStack input, World world) {
                return MetalPressPackingRecipes.getUnpackingCached(input, world);
            }
        };
    }

    public static RecipeDelegate getRecipeDelegate(ResourceLocation id) {
        if (!id.toString().startsWith("immersiveengineering:metalpress/packing_") && !id.toString().startsWith("immersiveengineering:metalpress/unpacking_")) {
            return null;
        }
        boolean packing = id.toString().startsWith("immersiveengineering:metalpress/packing_");
        String recipeId = packing ? id.toString().substring("immersiveengineering:metalpress/packing_".length()) : id.toString().substring("immersiveengineering:metalpress/unpacking_".length());
        ICraftingRecipe recipe = CRAFTING_RECIPE_MAP.get(new ResourceLocation(recipeId = recipeId.replaceFirst("\\.\\.", ":")));
        if (recipe == null) {
            return null;
        }
        NonNullList ingredients = recipe.func_192400_c();
        if (packing && ingredients.size() != 4 && ingredients.size() != 9) {
            return null;
        }
        if (!packing && ingredients.size() != 1) {
            return null;
        }
        ItemStack input = ((Ingredient)ingredients.get(0)).func_193365_a()[0];
        if (packing) {
            return RecipeDelegate.getPacking((Pair<ICraftingRecipe, ItemStack>)Pair.of((Object)recipe, (Object)recipe.func_77571_b()), input, ingredients.size() == 9);
        }
        return RecipeDelegate.getUnpacking((Pair<ICraftingRecipe, ItemStack>)Pair.of((Object)recipe, (Object)recipe.func_77571_b()), input);
    }

    public static Pair<ICraftingRecipe, ItemStack> getPackedOutput(int gridSize, ItemStack stack, World world) {
        CraftingInventory invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(gridSize, gridSize, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)(gridSize * gridSize), (Object)stack.func_77946_l()));
        return world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)invC, world).map(recipe -> Pair.of((Object)recipe, (Object)recipe.func_77572_b((IInventory)invC))).orElse(null);
    }

    private static RecipeDelegate getUnpackingCached(ItemStack input, World world) {
        ComparableItemStack comp = new ComparableItemStack(input, false);
        if (UNPACKING_CACHE.containsKey(comp)) {
            return UNPACKING_CACHE.get(comp);
        }
        comp.copy();
        Pair<ICraftingRecipe, ItemStack> out = MetalPressPackingRecipes.getPackedOutput(1, input, world);
        if (out == null) {
            return null;
        }
        ItemStack outStack = (ItemStack)out.getRight();
        int count = outStack.func_190916_E();
        if (count != 4 && count != 9) {
            UNPACKING_CACHE.put(comp, null);
            return null;
        }
        Pair<ICraftingRecipe, ItemStack> rePacked = MetalPressPackingRecipes.getPackedOutput(count == 4 ? 2 : 3, outStack, world);
        if (rePacked == null || ((ItemStack)rePacked.getRight()).func_190926_b() || !ItemStack.func_77989_b((ItemStack)input, (ItemStack)((ItemStack)rePacked.getRight()))) {
            UNPACKING_CACHE.put(comp, null);
            return null;
        }
        RecipeDelegate delegate = RecipeDelegate.getUnpacking(out, ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)1));
        UNPACKING_CACHE.put(comp, delegate);
        return delegate;
    }

    static {
        UNPACKING_CACHE = new HashMap();
    }

    public static class RecipeDelegate
    extends MetalPressRecipe {
        private RecipeDelegate(String id, ItemStack output, ItemStack input, Item mold) {
            super(new ResourceLocation("immersiveengineering", id), output, IngredientWithSize.of(input), new ComparableItemStack(new ItemStack((IItemProvider)mold)), 3200);
        }

        public static RecipeDelegate getPacking(Pair<ICraftingRecipe, ItemStack> originalRecipe, ItemStack input, boolean big) {
            ItemStack output = (ItemStack)originalRecipe.getRight();
            ResourceLocation originalId = ((ICraftingRecipe)originalRecipe.getLeft()).func_199560_c();
            String id = "metalpress/packing_" + originalId.func_110624_b() + ".." + originalId.func_110623_a();
            input = ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)(big ? 9 : 4));
            return new RecipeDelegate(id, output, input, big ? IEItems.Molds.moldPacking9 : IEItems.Molds.moldPacking4);
        }

        public static RecipeDelegate getUnpacking(Pair<ICraftingRecipe, ItemStack> originalRecipe, ItemStack input) {
            ItemStack output = (ItemStack)originalRecipe.getRight();
            ResourceLocation originalId = ((ICraftingRecipe)originalRecipe.getLeft()).func_199560_c();
            String id = "metalpress/unpacking_" + originalId.func_110624_b() + ".." + originalId.func_110623_a();
            return new RecipeDelegate(id, output, input, IEItems.Molds.moldUnpacking);
        }

        @Override
        public boolean listInJEI() {
            return false;
        }
    }

    public static class MetalPressPackingRecipe
    extends MetalPressContainerRecipe {
        private final int size;
        private final Map<ComparableItemStack, RecipeDelegate> PACKING_CACHE = new HashMap<ComparableItemStack, RecipeDelegate>();

        public MetalPressPackingRecipe(ResourceLocation id, Item mold, int size) {
            super(id, mold);
            this.size = size;
        }

        @Override
        public boolean matches(ItemStack mold, ItemStack input, World world) {
            return input.func_190916_E() >= this.size * this.size && super.matches(mold, input, world);
        }

        @Override
        protected MetalPressRecipe getRecipeFunction(ItemStack input, World world) {
            ComparableItemStack comp = new ComparableItemStack(input, false);
            if (this.PACKING_CACHE.containsKey(comp)) {
                return this.PACKING_CACHE.get(comp);
            }
            int totalSize = this.size * this.size;
            comp.copy();
            Pair<ICraftingRecipe, ItemStack> out = MetalPressPackingRecipes.getPackedOutput(this.size, input, world);
            if (out == null) {
                return null;
            }
            ItemStack outStack = (ItemStack)out.getRight();
            if (outStack.func_190926_b()) {
                this.PACKING_CACHE.put(comp, null);
                return null;
            }
            RecipeDelegate delegate = RecipeDelegate.getPacking(out, ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)totalSize), this.size == 3);
            this.PACKING_CACHE.put(comp, delegate);
            return delegate;
        }
    }

    public static abstract class MetalPressContainerRecipe
    extends MetalPressRecipe {
        public MetalPressContainerRecipe(ResourceLocation id, Item mold) {
            super(id, ItemStack.field_190927_a, new IngredientWithSize(Ingredient.field_193370_a), new ComparableItemStack(new ItemStack((IItemProvider)mold)), 3200);
        }

        @Override
        public boolean listInJEI() {
            return false;
        }

        @Override
        public boolean matches(ItemStack mold, ItemStack input, World world) {
            return this.getRecipeFunction(input, world) != null;
        }

        @Override
        public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input, World world) {
            return this.getRecipeFunction(input, world);
        }

        protected abstract MetalPressRecipe getRecipeFunction(ItemStack var1, World var2);
    }
}

