/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ShaderBagItem
extends IEBaseItem {
    @Nonnull
    private final Rarity rarity;

    public ShaderBagItem(Rarity rarity) {
        super("shader_bag_" + rarity.name().toLowerCase(Locale.US).replace(':', '_'), new Item.Properties());
        this.rarity = rarity;
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        return this.rarity.field_77937_e.func_211163_e();
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent("desc.immersiveengineering.info.shader.rarity." + this.rarity.name().toLowerCase(Locale.US)).func_240702_b_(" ").func_230529_a_(super.func_200295_i(stack));
    }

    public String func_77658_a() {
        return "item.immersiveengineering.shader_bag";
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && ShaderRegistry.totalWeight.containsKey(this.rarity)) {
            ResourceLocation shader = ShaderRegistry.getRandomShader(player.func_110124_au(), player.func_70681_au(), this.rarity, true);
            if (shader == null) {
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
            ItemStack shaderItem = new ItemStack((IItemProvider)IEItems.Misc.shader);
            ItemNBTHelper.putString(shaderItem, "shader_name", shader.toString());
            Rarity shaderRarity = ShaderRegistry.shaderRegistry.get(shader).getRarity();
            if (ShaderRegistry.sortedRarityMap.indexOf(shaderRarity) <= ShaderRegistry.sortedRarityMap.indexOf(Rarity.EPIC) && ShaderRegistry.sortedRarityMap.indexOf(this.rarity) >= ShaderRegistry.sortedRarityMap.indexOf(Rarity.COMMON)) {
                Utils.unlockIEAdvancement(player, "main/secret_luckofthedraw");
            }
            stack.func_190918_g(1);
            if (stack.func_190916_E() <= 0) {
                return new ActionResult(ActionResultType.SUCCESS, (Object)shaderItem);
            }
            if (!player.field_71071_by.func_70441_a(shaderItem)) {
                player.func_146097_a(shaderItem, false, true);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }
}

