/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient.capability;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.capability.AttachCapabilitiesEventIngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.capability.IIngredientComponentCapabilityAttacher;

public class IngredientComponentCapabilityAttacherManager {
    private final Multimap<ResourceLocation, IIngredientComponentCapabilityAttacher<?, ?>> attachers = MultimapBuilder.hashKeys().arrayListValues().build();

    public IngredientComponentCapabilityAttacherManager() {
        CommonCapabilities._instance.getModEventBus().register((Object)this);
    }

    public void addAttacher(IIngredientComponentCapabilityAttacher<?, ?> attacher) {
        this.attachers.put((Object)attacher.getTargetName(), attacher);
    }

    @SubscribeEvent
    public void onIngredientComponentsLoad(AttachCapabilitiesEventIngredientComponent event) {
        this.onIngredientComponentLoad(event, event.getIngredientComponent());
    }

    protected <T, M> void onIngredientComponentLoad(AttachCapabilitiesEventIngredientComponent event, IngredientComponent<T, M> ingredientComponent) {
        for (IIngredientComponentCapabilityAttacher attacher : this.attachers.get((Object)ingredientComponent.getName())) {
            event.addCapability(attacher.getCapabilityProviderName(), attacher.createCapabilityProvider(ingredientComponent));
        }
    }
}

