/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui;

import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.panel.InfoPanel;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.client.gui.element.panel.PanelTracker;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.client.gui.IGuiAccess;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ContainerScreenCoFH<T extends Container>
extends ContainerScreen<T>
implements IGuiAccess {
    protected int mX;
    protected int mY;
    protected String name = "";
    protected String info = "";
    protected ResourceLocation texture;
    protected PlayerEntity player;
    protected boolean drawTitle = true;
    protected boolean drawInventory = true;
    protected boolean showTooltips = true;
    private final ArrayList<PanelBase> panels = new ArrayList();
    private final ArrayList<ElementBase> elements = new ArrayList();
    private final List<ITextComponent> tooltip = new LinkedList<ITextComponent>();

    public ContainerScreenCoFH(T container, PlayerInventory inv, ITextComponent titleIn) {
        super(container, inv, titleIn);
        this.player = inv.field_70458_d;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.panels.clear();
        this.elements.clear();
        if (this.info != null && !this.info.isEmpty()) {
            this.addPanel(new InfoPanel((IGuiAccess)this, this.info));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        this.mX = mouseX - this.field_147003_i;
        this.mY = mouseY - this.field_147009_r;
        this.updatePanels();
        this.updateElements();
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (this.showTooltips && this.getMinecraft().field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.drawTooltip(matrixStack);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderHelper.resetColor();
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawPanels(matrixStack, false);
        this.drawElements(matrixStack, false);
        RenderSystem.popMatrix();
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.drawTitle & this.field_230704_d_ != null) {
            this.getFontRenderer().func_238421_b_(matrixStack, StringHelper.localize(this.field_230704_d_.getString()), (float)this.getCenteredOffset(StringHelper.localize(this.field_230704_d_.getString())), 6.0f, 0x404040);
        }
        if (this.drawInventory) {
            this.getFontRenderer().func_238421_b_(matrixStack, StringHelper.localize("container.inventory"), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        }
        this.drawPanels(matrixStack, true);
        this.drawElements(matrixStack, true);
    }

    public void drawTooltip(MatrixStack matrixStack) {
        ElementBase element;
        PanelBase panel = this.getPanelAtPosition(this.mX, this.mY);
        if (panel != null) {
            panel.addTooltip(this.tooltip, this.mX, this.mY);
        }
        if ((element = this.getElementAtPosition(this.mX, this.mY)) != null && element.visible()) {
            element.addTooltip(this.tooltip, this.mX, this.mY);
        }
        GuiUtils.drawHoveringText((MatrixStack)matrixStack, this.tooltip, (int)(this.mX + this.field_147003_i), (int)(this.mY + this.field_147009_r), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        this.tooltip.clear();
    }

    protected void drawElements(MatrixStack matrixStack, boolean foreground) {
        if (foreground) {
            for (ElementBase c : this.elements) {
                if (!c.visible()) continue;
                c.drawForeground(matrixStack, this.mX, this.mY);
            }
        } else {
            for (ElementBase c : this.elements) {
                if (!c.visible()) continue;
                c.drawBackground(matrixStack, this.mX, this.mY);
            }
        }
    }

    protected void drawPanels(MatrixStack matrixStack, boolean foreground) {
        int yPosRight = 4;
        int yPosLeft = 4;
        if (foreground) {
            for (PanelBase panel : this.panels) {
                panel.updateSize();
                if (!panel.visible()) continue;
                if (panel.side == 0) {
                    panel.drawForeground(matrixStack, this.mX, this.mY);
                    yPosLeft += panel.height();
                    continue;
                }
                panel.drawForeground(matrixStack, this.mX, this.mY);
                yPosRight += panel.height();
            }
        } else {
            for (PanelBase panel : this.panels) {
                panel.updateSize();
                if (!panel.visible()) continue;
                if (panel.side == 0) {
                    panel.setPosition(0, yPosLeft);
                    panel.drawBackground(matrixStack, this.mX, this.mY);
                    yPosLeft += panel.height();
                    continue;
                }
                panel.setPosition(this.field_146999_f, yPosRight);
                panel.drawBackground(matrixStack, this.mX, this.mY);
                yPosRight += panel.height();
            }
        }
    }

    protected <T> T addElement(ElementBase element) {
        this.elements.add(element);
        return (T)element;
    }

    public final void addElements(ElementBase ... c) {
        this.elements.addAll(Arrays.asList(c));
    }

    protected <T> T addPanel(PanelBase panel) {
        int yOffset = 4;
        for (PanelBase panel1 : this.panels) {
            if (panel1.side != panel.side || !panel1.visible()) continue;
            yOffset += panel1.height();
        }
        panel.setPosition(panel.side == 0 ? 0 : this.field_146999_f, yOffset);
        this.panels.add(panel);
        if (PanelTracker.getOpenedLeft() != null && panel.getClass().equals(PanelTracker.getOpenedLeft())) {
            panel.setFullyOpen();
        } else if (PanelTracker.getOpenedRight() != null && panel.getClass().equals(PanelTracker.getOpenedRight())) {
            panel.setFullyOpen();
        }
        return (T)panel;
    }

    private ElementBase getElementAtPosition(int mouseX, int mouseY) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase element = this.elements.get(i);
            if (!element.intersectsWith(mouseX, mouseY) || !element.visible()) continue;
            return element;
        }
        return null;
    }

    private PanelBase getPanelAtPosition(double mouseX, double mouseY) {
        int xShift = 0;
        int yShift = 4;
        for (PanelBase panel : this.panels) {
            if (!panel.visible() || panel.side == 1) continue;
            panel.setShift(xShift, yShift);
            if (panel.intersectsWith(mouseX, mouseY, xShift, yShift)) {
                return panel;
            }
            yShift += panel.height();
        }
        xShift = this.field_146999_f;
        yShift = 4;
        for (PanelBase panel : this.panels) {
            if (!panel.visible() || panel.side == 0) continue;
            panel.setShift(xShift, yShift);
            if (panel.intersectsWith(mouseX, mouseY, xShift, yShift)) {
                return panel;
            }
            yShift += panel.height();
        }
        return null;
    }

    private void updateElements() {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled()) continue;
            c.update(this.mX, this.mY);
        }
    }

    private void updatePanels() {
        int i = this.panels.size();
        while (i-- > 0) {
            PanelBase c = this.panels.get(i);
            if (!c.visible() || !c.enabled()) continue;
            c.update(this.mX, this.mY);
        }
    }

    public List<Rectangle2d> getPanelBounds() {
        ArrayList<Rectangle2d> panelBounds = new ArrayList<Rectangle2d>();
        for (PanelBase c : this.panels) {
            panelBounds.add(c.getBoundsOnScreen());
        }
        return panelBounds;
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.func_195361_a(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.getPanelAtPosition(mouseX - (double)guiLeftIn, mouseY - (double)guiTopIn) == null;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        mouseX -= (double)this.field_147003_i;
        mouseY -= (double)this.field_147009_r;
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled() || !c.intersectsWith(mouseX, mouseY) || !c.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        PanelBase panel = this.getPanelAtPosition(mouseX, mouseY);
        if (panel != null && !panel.mouseClicked(mouseX, mouseY, mouseButton)) {
            int i2 = this.panels.size();
            while (i2-- > 0) {
                PanelBase other = this.panels.get(i2);
                if (other == panel || !other.open || other.side != panel.side) continue;
                other.toggleOpen();
            }
            panel.toggleOpen();
            return true;
        }
        if (panel != null) {
            switch (panel.side) {
                case 0: {
                    this.field_147003_i -= panel.width();
                    break;
                }
                case 1: {
                    this.field_146999_f += panel.width();
                }
            }
        }
        boolean ret = super.func_231044_a_(mouseX += (double)this.field_147003_i, mouseY += (double)this.field_147009_r, mouseButton);
        if (panel != null) {
            switch (panel.side) {
                case 0: {
                    this.field_147003_i += panel.width();
                    break;
                }
                case 1: {
                    this.field_146999_f -= panel.width();
                }
            }
        }
        return ret;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        mouseX -= (double)this.field_147003_i;
        mouseY -= (double)this.field_147009_r;
        if (mouseButton >= 0 && mouseButton <= 2) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.visible() || !c.enabled()) continue;
                c.mouseReleased(mouseX, mouseY);
            }
        }
        return super.func_231048_c_(mouseX += (double)this.field_147003_i, mouseY += (double)this.field_147009_r, mouseButton);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double movement) {
        if (movement != 0.0) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.visible() || !c.enabled() || !c.intersectsWith(this.mX, this.mY) || !c.mouseWheel(this.mX, this.mY, movement)) continue;
                return true;
            }
            PanelBase panel = this.getPanelAtPosition(this.mX, this.mY);
            if (panel != null && panel.mouseWheel(this.mX, this.mY, movement)) {
                return true;
            }
            return this.mouseWheel(this.mX, this.mY, movement);
        }
        return false;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled() || !c.keyTyped(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) continue;
            return true;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected boolean mouseWheel(double mouseX, double mouseY, double movement) {
        return false;
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_146999_f / 2);
    }

    protected int getCenteredOffset(String string, int xPos) {
        return (xPos * 2 - this.field_230712_o_.func_78256_a(string)) / 2;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public boolean handleElementButtonClick(String buttonName, int mouseButton) {
        return false;
    }

    @Override
    public void drawIcon(MatrixStack matrixStack, TextureAtlasSprite icon, int x, int y) {
        RenderHelper.setBlockTextureSheet();
        RenderHelper.resetColor();
        ContainerScreenCoFH.func_238470_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)icon);
    }

    @Override
    public void drawIcon(MatrixStack matrixStack, TextureAtlasSprite icon, int color, int x, int y) {
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setGLColorFromInt(color);
        ContainerScreenCoFH.func_238470_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)icon);
        RenderHelper.resetColor();
    }

    @Override
    public void drawSizedRect(int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)x1, (double)y2, (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y2, (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y1, (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y1, (double)this.func_230927_p_()).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
    }

    @Override
    public void drawColoredModalRect(int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFunc((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)x1, (double)y2, (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y2, (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y1, (double)this.func_230927_p_()).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y1, (double)this.func_230927_p_()).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    @Override
    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + height), (double)this.func_230927_p_()).func_225583_a_((float)(textureX + 0) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), (double)this.func_230927_p_()).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + 0), (double)this.func_230927_p_()).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + 0), (double)this.func_230927_p_()).func_225583_a_((float)(textureX + 0) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, float texW, float texH) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), (double)this.func_230927_p_()).func_225583_a_((float)u * texU, (float)(v + height) * texV).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)this.func_230927_p_()).func_225583_a_((float)(u + width) * texU, (float)(v + height) * texV).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, (double)this.func_230927_p_()).func_225583_a_((float)(u + width) * texU, (float)v * texV).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, (double)this.func_230927_p_()).func_225583_a_((float)u * texU, (float)v * texV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

