/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.element.ElementScaled;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.client.gui.IGuiAccess;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Supplier;
import net.minecraftforge.fluids.FluidStack;

public class ElementScaledFluid
extends ElementScaled {
    protected Supplier<FluidStack> fluidSup;

    public ElementScaledFluid(IGuiAccess gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public ElementScaledFluid setFluid(Supplier<FluidStack> sup) {
        this.fluidSup = sup;
        return this;
    }

    @Override
    public void drawBackground(MatrixStack matrixStack, int mouseX, int mouseY) {
        RenderHelper.bindTexture(this.texture);
        int quantity = this.quantitySup.getAsInt();
        FluidStack fluid = this.fluidSup.get();
        if (this.drawBackground) {
            this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
        switch (this.direction) {
            case TOP: {
                RenderHelper.drawFluid(this.posX(), this.posY(), fluid, this.width, quantity);
                RenderHelper.bindTexture(this.texture);
                this.drawTexturedModalRect(this.posX(), this.posY(), this.width, 0, this.width, quantity);
                return;
            }
            case BOTTOM: {
                RenderHelper.drawFluid(this.posX(), this.posY() + this.height - quantity, fluid, this.width, quantity);
                RenderHelper.bindTexture(this.texture);
                this.drawTexturedModalRect(this.posX(), this.posY() + this.height - quantity, this.width, this.height - quantity, this.width, quantity);
                return;
            }
            case LEFT: {
                RenderHelper.drawFluid(this.posX(), this.posY(), fluid, quantity, this.height);
                RenderHelper.bindTexture(this.texture);
                this.drawTexturedModalRect(this.posX(), this.posY(), this.width, 0, quantity, this.height);
                return;
            }
            case RIGHT: {
                RenderHelper.drawFluid(this.posX() + this.width - quantity, this.posY(), fluid, quantity, this.height);
                RenderHelper.bindTexture(this.texture);
                this.drawTexturedModalRect(this.posX() + this.width - quantity, this.posY(), this.width + this.width - quantity, 0, quantity, this.height);
            }
        }
    }
}

