/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.control.IReconfigurableTile;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.control.IReconfigurable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SideConfigPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected IReconfigurable.SideConfig[] sides = new IReconfigurable.SideConfig[]{IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE};

    public SideConfigPacket() {
        super(36, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.func_195588_v(this.pos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof IReconfigurableTile) {
            ((IReconfigurableTile)tile).reconfigControl().setSideConfig(this.sides);
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        byte[] bSides = new byte[6];
        for (int i = 0; i < 6; ++i) {
            bSides[i] = (byte)this.sides[i].ordinal();
        }
        buf.func_179250_a(bSides);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        byte[] bSides = buf.func_189425_b(6);
        if (bSides.length == 6) {
            for (int i = 0; i < 6; ++i) {
                if (bSides[i] > IReconfigurable.SideConfig.VALUES.length) {
                    bSides[i] = 0;
                }
                this.sides[i] = IReconfigurable.SideConfig.VALUES[bSides[i]];
            }
        }
    }

    public static void sendToServer(IReconfigurableTile tile) {
        SideConfigPacket packet = new SideConfigPacket();
        packet.pos = tile.pos();
        packet.sides = tile.reconfigControl().getSideConfig();
        packet.sendToServer();
    }
}

