/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.tileentity;

import cofh.core.network.packet.client.TileGuiPacket;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.tileentity.IAreaEffectTile;
import cofh.lib.tileentity.ITileCallback;
import cofh.lib.tileentity.ITilePacketHandler;
import cofh.lib.tileentity.ITileXpHandler;
import cofh.lib.util.IConveyableData;
import cofh.lib.util.Utils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileCoFH
extends TileEntity
implements ITileCallback,
ITilePacketHandler,
ITileXpHandler,
IConveyableData {
    protected int numPlayersUsing;

    public TileCoFH(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b != null && Utils.isClientWorld(this.field_145850_b)) {
            if (!this.hasClientUpdate()) {
                this.field_145850_b.field_175730_i.remove(this);
            }
            if (this instanceof IAreaEffectTile) {
                ProxyUtils.addAreaEffectTile((IAreaEffectTile)((Object)this));
            }
        }
        this.func_145829_t();
    }

    public void func_145843_s() {
        if (this instanceof IAreaEffectTile) {
            ProxyUtils.removeAreaEffectTile((IAreaEffectTile)((Object)this));
        }
        super.func_145843_s();
    }

    public int getPlayersUsing() {
        return this.numPlayersUsing;
    }

    public void addPlayerUsing() {
        ++this.numPlayersUsing;
    }

    public void removePlayerUsing() {
        --this.numPlayersUsing;
    }

    public void receiveGuiNetworkData(int id, int data) {
    }

    public void sendGuiNetworkData(Container container, IContainerListener player) {
        if (this.hasGuiPacket() && player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            TileGuiPacket.sendToClient(this, (ServerPlayerEntity)player);
        }
    }

    public TileCoFH worldContext(BlockState state, IBlockReader world) {
        return this;
    }

    public boolean onActivatedDelegate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        return this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(handler -> FluidHelper.interactWithHandler(player.func_184586_b(hand), handler, player, hand)).orElse(false);
    }

    public boolean hasClientUpdate() {
        return false;
    }

    public boolean hasGuiPacket() {
        return true;
    }

    public void animateTick(BlockState state, World worldIn, BlockPos pos, Random rand) {
    }

    protected Object getSound() {
        return null;
    }

    protected void markDirtyFast() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public boolean playerWithinDistance(PlayerEntity player, double distanceSq) {
        return !this.func_145837_r() && this.field_174879_c.func_218138_a((IPosition)player.func_213303_ch(), true) <= distanceSq;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_195045_e, pkt.func_148857_g());
    }

    @Override
    public Block block() {
        return this.func_195044_w().func_177230_c();
    }

    @Override
    public BlockState state() {
        return this.func_195044_w();
    }

    @Override
    public BlockPos pos() {
        return this.field_174879_c;
    }

    @Override
    public World world() {
        return this.field_145850_b;
    }
}

