/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.impl.rails;

import cofh.lib.block.IDismantleable;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CrossoverRailBlock
extends AbstractRailBlock
implements IDismantleable {
    protected float maxSpeed = 0.4f;

    public CrossoverRailBlock(AbstractBlock.Properties builder) {
        super(true, builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(this.func_176560_l(), (Comparable)RailShape.NORTH_SOUTH));
    }

    public CrossoverRailBlock speed(float maxSpeed) {
        this.maxSpeed = MathHelper.clamp(maxSpeed, 0.0f, 1.0f);
        return this;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.func_176560_l()});
    }

    public float getRailMaxSpeed(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        return this.maxSpeed;
    }

    public Property<RailShape> func_176560_l() {
        return Constants.RAIL_STRAIGHT_FLAT;
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public RailShape getRailDirection(BlockState state, IBlockReader world, BlockPos pos, @Nullable AbstractMinecartEntity cart) {
        if (cart != null) {
            double absZ;
            double absX = Math.abs(cart.func_213322_ci().field_72450_a);
            if (absX > (absZ = Math.abs(cart.func_213322_ci().field_72449_c))) {
                return RailShape.EAST_WEST;
            }
            if (absZ > absX) {
                return RailShape.NORTH_SOUTH;
            }
        }
        return (RailShape)state.func_177229_b(this.func_176560_l());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (Utils.isWrench(player.func_184586_b(handIn).func_77973_b())) {
            if (player.func_226563_dT_()) {
                if (this.canDismantle(worldIn, pos, state, player)) {
                    this.dismantleBlock(worldIn, pos, state, (RayTraceResult)hit, player, false);
                    return ActionResultType.SUCCESS;
                }
            } else {
                BlockState rotState = this.rotate(state, (IWorld)worldIn, pos, Rotation.CLOCKWISE_90);
                if (rotState != state) {
                    worldIn.func_175656_a(pos, rotState);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.PASS;
    }
}

