/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.filter;

import java.util.function.Predicate;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;

public interface IFilter
extends INBTSerializable<CompoundNBT>,
INamedContainerProvider {
    public static final Predicate<ItemStack> ALWAYS_ALLOW_ITEM = stack -> true;
    public static final Predicate<FluidStack> ALWAYS_ALLOW_FLUID = stack -> true;

    default public Predicate<ItemStack> getItemRules() {
        return ALWAYS_ALLOW_ITEM;
    }

    default public Predicate<FluidStack> getFluidRules() {
        return ALWAYS_ALLOW_FLUID;
    }

    default public boolean valid(ItemStack item) {
        return this.getItemRules().test(item);
    }

    default public boolean valid(FluidStack fluid) {
        return this.getFluidRules().test(fluid);
    }

    public IFilter read(CompoundNBT var1);

    public CompoundNBT write(CompoundNBT var1);

    default public CompoundNBT serializeNBT() {
        return this.write(new CompoundNBT());
    }

    default public void deserializeNBT(CompoundNBT nbt) {
        this.read(nbt);
    }
}

