/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.batchedentityrendering.impl;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.coderbot.batchedentityrendering.impl.BlendingStateHolder;
import net.coderbot.batchedentityrendering.impl.TransparencyType;
import net.coderbot.batchedentityrendering.impl.WrappableRenderType;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;

public class OldFullyBufferedMultiBufferSource
extends IRenderTypeBuffer.Impl {
    private final Map<RenderType, BufferBuilder> bufferBuilders = new HashMap<RenderType, BufferBuilder>();
    private final Object2IntMap<RenderType> unused = new Object2IntOpenHashMap();
    private final Set<BufferBuilder> activeBuffers = new HashSet<BufferBuilder>();
    private boolean flushed = false;
    private final Set<RenderType> typesThisFrame = new HashSet<RenderType>();
    private final List<RenderType> typesInOrder = new ArrayList<RenderType>();

    public OldFullyBufferedMultiBufferSource() {
        super(new BufferBuilder(0), Collections.emptyMap());
    }

    private TransparencyType getTransparencyType(RenderType type) {
        while (type instanceof WrappableRenderType) {
            type = ((WrappableRenderType)type).unwrap();
        }
        if (type instanceof BlendingStateHolder) {
            return ((BlendingStateHolder)type).getTransparencyType();
        }
        return TransparencyType.GENERAL_TRANSPARENT;
    }

    public IVertexBuilder getBuffer(RenderType renderType) {
        this.flushed = false;
        BufferBuilder buffer = this.bufferBuilders.computeIfAbsent(renderType, type -> new BufferBuilder(type.func_228662_o_()));
        if (this.activeBuffers.add(buffer)) {
            buffer.func_181668_a(renderType.func_228664_q_(), renderType.func_228663_p_());
        }
        if (this.typesThisFrame.add(renderType)) {
            this.typesInOrder.add(renderType);
        }
        this.unused.removeInt((Object)renderType);
        return buffer;
    }

    public void func_228461_a_() {
        if (this.flushed) {
            return;
        }
        ArrayList removedTypes = new ArrayList();
        this.unused.forEach((unusedType, unusedCount) -> {
            if (unusedCount < 10) {
                return;
            }
            BufferBuilder buffer = this.bufferBuilders.remove(unusedType);
            removedTypes.add(unusedType);
            if (this.activeBuffers.contains(buffer)) {
                throw new IllegalStateException("A buffer was simultaneously marked as inactive and as active, something is very wrong...");
            }
        });
        for (RenderType removed : removedTypes) {
            this.unused.removeInt((Object)removed);
        }
        this.typesInOrder.sort(Comparator.comparing(this::getTransparencyType));
        for (RenderType type : this.typesInOrder) {
            this.drawInternal(type);
        }
        this.typesInOrder.clear();
        this.typesThisFrame.clear();
        this.flushed = true;
    }

    public void func_228462_a_(RenderType type) {
    }

    private void drawInternal(RenderType type) {
        BufferBuilder buffer = this.bufferBuilders.get(type);
        if (buffer == null) {
            return;
        }
        if (this.activeBuffers.remove(buffer)) {
            type.func_228631_a_(buffer, 0, 0, 0);
            buffer.func_178965_a();
        } else {
            int unusedCount = this.unused.getOrDefault((Object)type, 0);
            this.unused.put((Object)type, ++unusedCount);
        }
    }
}

