/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.blending;

import com.mojang.blaze3d.platform.GlStateManager;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.BlendMode;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.statelisteners.BooleanStateAccessor;

public class BlendModeStorage {
    private static boolean originalBlendEnable;
    private static BlendMode originalBlend;
    private static boolean blendLocked;

    public static boolean isBlendLocked() {
        return blendLocked;
    }

    public static void overrideBlend(BlendMode override) {
        if (!blendLocked) {
            GlStateManager.BlendState blendState = GlStateManagerAccessor.getBLEND();
            originalBlendEnable = ((BooleanStateAccessor)blendState.field_179213_a).isEnabled();
            originalBlend = new BlendMode(blendState.field_179211_b, blendState.field_179212_c, blendState.field_179209_d, blendState.field_179210_e);
        }
        blendLocked = false;
        if (override == null) {
            GlStateManager.func_227737_l_();
        } else {
            GlStateManager.func_227740_m_();
            GlStateManager.func_227644_a_((int)override.getSrcRgb(), (int)override.getDstRgb(), (int)override.getSrcAlpha(), (int)override.getDstAlpha());
        }
        blendLocked = true;
    }

    public static void overrideBufferBlend(int index, BlendMode override) {
        if (!blendLocked) {
            GlStateManager.BlendState blendState = GlStateManagerAccessor.getBLEND();
            originalBlendEnable = ((BooleanStateAccessor)blendState.field_179213_a).isEnabled();
            originalBlend = new BlendMode(blendState.field_179211_b, blendState.field_179212_c, blendState.field_179209_d, blendState.field_179210_e);
        }
        if (override == null) {
            IrisRenderSystem.disableBufferBlend(index);
        } else {
            IrisRenderSystem.enableBufferBlend(index);
            IrisRenderSystem.blendFuncSeparatei(index, override.getSrcRgb(), override.getDstRgb(), override.getSrcAlpha(), override.getDstAlpha());
        }
        blendLocked = true;
    }

    public static void deferBlendModeToggle(boolean enabled) {
        originalBlendEnable = enabled;
    }

    public static void deferBlendFunc(int srcRgb, int dstRgb, int srcAlpha, int dstAlpha) {
        originalBlend = new BlendMode(srcRgb, dstRgb, srcAlpha, dstAlpha);
    }

    public static void restoreBlend() {
        if (!blendLocked) {
            return;
        }
        blendLocked = false;
        if (originalBlendEnable) {
            GlStateManager.func_227740_m_();
        } else {
            GlStateManager.func_227737_l_();
        }
        GlStateManager.func_227644_a_((int)originalBlend.getSrcRgb(), (int)originalBlend.getDstRgb(), (int)originalBlend.getSrcAlpha(), (int)originalBlend.getDstAlpha());
    }
}

