/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOptionElementWidget<T extends OptionMenuElement>
extends CommentedElementWidget<T> {
    protected static final ITextComponent SET_TO_DEFAULT = new TranslationTextComponent("options.iris.setToDefault").func_240699_a_(TextFormatting.GREEN);
    protected static final ITextComponent DIVIDER = new StringTextComponent(": ");
    protected IFormattableTextComponent unmodifiedLabel;
    protected ShaderPackScreen screen;
    protected NavigationController navigation;
    private IFormattableTextComponent label;
    protected ITextComponent trimmedLabel;
    protected ITextComponent valueLabel;
    private boolean isLabelTrimmed;
    private int maxLabelWidth;
    private int valueSectionWidth;

    public BaseOptionElementWidget(T element) {
        super(element);
    }

    @Override
    public void init(ShaderPackScreen screen, NavigationController navigation) {
        this.screen = screen;
        this.navigation = navigation;
        this.valueLabel = null;
        this.trimmedLabel = null;
    }

    protected final void setLabel(IFormattableTextComponent label) {
        this.label = label.func_230532_e_().func_230529_a_(DIVIDER);
        this.unmodifiedLabel = label;
    }

    protected final void updateRenderParams(int width, int minValueSectionWidth) {
        if (this.valueLabel == null) {
            this.valueLabel = this.createValueLabel();
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.valueSectionWidth = Math.max(minValueSectionWidth, font.func_238414_a_((ITextProperties)this.valueLabel) + 8);
        this.maxLabelWidth = width - 8 - this.valueSectionWidth;
        if (this.trimmedLabel == null || font.func_238414_a_((ITextProperties)this.label) > this.maxLabelWidth != this.isLabelTrimmed) {
            this.updateLabels();
        }
        this.isLabelTrimmed = font.func_238414_a_((ITextProperties)this.label) > this.maxLabelWidth;
    }

    protected final void renderOptionWithValue(MatrixStack poseStack, int x, int y, int width, int height, boolean hovered, float sliderPosition, int sliderWidth) {
        GuiUtil.bindIrisWidgetsTexture();
        GuiUtil.drawButton(poseStack, x, y, width, height, hovered, false);
        GuiUtil.drawButton(poseStack, x + width - (this.valueSectionWidth + 2), y + 2, this.valueSectionWidth, height - 4, false, true);
        if (sliderPosition >= 0.0f) {
            int sliderSpace = this.valueSectionWidth - 4 - sliderWidth;
            int sliderPos = x + width - this.valueSectionWidth + (int)(sliderPosition * (float)sliderSpace);
            GuiUtil.drawButton(poseStack, sliderPos, y + 4, sliderWidth, height - 8, false, false);
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.func_243246_a(poseStack, this.trimmedLabel, (float)(x + 6), (float)(y + 7), 0xFFFFFF);
        font.func_243246_a(poseStack, this.valueLabel, (float)(x + (width - 2) - (int)((double)this.valueSectionWidth * 0.5) - (int)((double)font.func_238414_a_((ITextProperties)this.valueLabel) * 0.5)), (float)(y + 7), 0xFFFFFF);
    }

    protected final void renderOptionWithValue(MatrixStack poseStack, int x, int y, int width, int height, boolean hovered) {
        this.renderOptionWithValue(poseStack, x, y, width, height, hovered, -1.0f, 0);
    }

    protected final void tryRenderTooltip(MatrixStack poseStack, int mouseX, int mouseY, boolean hovered) {
        if (Screen.func_231173_s_()) {
            this.renderTooltip(poseStack, SET_TO_DEFAULT, mouseX, mouseY, hovered);
        } else if (this.isLabelTrimmed && !this.screen.isDisplayingComment()) {
            this.renderTooltip(poseStack, (ITextComponent)this.unmodifiedLabel, mouseX, mouseY, hovered);
        }
    }

    protected final void renderTooltip(MatrixStack poseStack, ITextComponent text, int mouseX, int mouseY, boolean hovered) {
        if (hovered) {
            ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(Minecraft.func_71410_x().field_71466_p, poseStack, text, mouseX + 2, mouseY - 16));
        }
    }

    protected final void updateLabels() {
        this.trimmedLabel = this.createTrimmedLabel();
        this.valueLabel = this.createValueLabel();
    }

    protected final ITextComponent createTrimmedLabel() {
        IFormattableTextComponent label = GuiUtil.shortenText(Minecraft.func_71410_x().field_71466_p, this.label.func_230532_e_(), this.maxLabelWidth);
        if (this.isValueModified()) {
            label = label.func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)16763210)));
        }
        return label;
    }

    protected abstract ITextComponent createValueLabel();

    public abstract boolean applyNextValue();

    public abstract boolean applyPreviousValue();

    public abstract boolean applyOriginalValue();

    public abstract boolean isValueModified();

    @Nullable
    public abstract String getCommentKey();

    @Override
    public Optional<ITextComponent> getCommentTitle() {
        return Optional.of(this.unmodifiedLabel);
    }

    @Override
    public Optional<ITextComponent> getCommentBody() {
        return Optional.ofNullable(this.getCommentKey()).map(key -> I18n.func_188566_a((String)key) ? new TranslationTextComponent(key) : null);
    }

    @Override
    public boolean mouseClicked(double mx, double my, int button) {
        if (button == 0 || button == 1) {
            boolean refresh = false;
            if (Screen.func_231173_s_()) {
                refresh = this.applyOriginalValue();
            }
            if (!refresh) {
                refresh = button == 0 ? this.applyNextValue() : this.applyPreviousValue();
            }
            if (refresh) {
                this.navigation.refresh();
            }
            GuiUtil.playButtonClickSound();
            return true;
        }
        return super.mouseClicked(mx, my, button);
    }
}

