/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuLinkElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LinkElementWidget
extends CommentedElementWidget<OptionMenuLinkElement> {
    private static final ITextComponent ARROW = new StringTextComponent(">");
    private final String targetScreenId;
    private final IFormattableTextComponent label;
    private NavigationController navigation;
    private IFormattableTextComponent trimmedLabel = null;
    private boolean isLabelTrimmed = false;

    public LinkElementWidget(OptionMenuLinkElement element) {
        super(element);
        this.targetScreenId = element.targetScreenId;
        this.label = GuiUtil.translateOrDefault((IFormattableTextComponent)new StringTextComponent(element.targetScreenId), "screen." + element.targetScreenId, new Object[0]);
    }

    @Override
    public void init(ShaderPackScreen screen, NavigationController navigation) {
        this.navigation = navigation;
    }

    @Override
    public void render(MatrixStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
        GuiUtil.bindIrisWidgetsTexture();
        GuiUtil.drawButton(poseStack, x, y, width, height, hovered, false);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int maxLabelWidth = width - 9;
        if (font.func_238414_a_((ITextProperties)this.label) > maxLabelWidth) {
            this.isLabelTrimmed = true;
        }
        if (this.trimmedLabel == null) {
            this.trimmedLabel = GuiUtil.shortenText(font, this.label, maxLabelWidth);
        }
        int labelWidth = font.func_238414_a_((ITextProperties)this.trimmedLabel);
        font.func_243246_a(poseStack, (ITextComponent)this.trimmedLabel, (float)(x + (int)((double)width * 0.5) - (int)((double)labelWidth * 0.5) - (int)(0.5 * (double)Math.max(labelWidth - (width - 18), 0))), (float)(y + 7), 0xFFFFFF);
        font.func_243248_b(poseStack, ARROW, (float)(x + width - 9), (float)(y + 7), 0xFFFFFF);
        if (hovered && this.isLabelTrimmed) {
            ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(font, poseStack, (ITextComponent)this.label, mouseX + 2, mouseY - 16));
        }
    }

    @Override
    public boolean mouseClicked(double mx, double my, int button) {
        if (button == 0) {
            this.navigation.open(this.targetScreenId);
            GuiUtil.playButtonClickSound();
            return true;
        }
        return super.mouseClicked(mx, my, button);
    }

    @Override
    public Optional<ITextComponent> getCommentTitle() {
        return Optional.of(this.label);
    }

    @Override
    public Optional<ITextComponent> getCommentBody() {
        String translation = "screen." + this.targetScreenId + ".comment";
        return Optional.ofNullable(I18n.func_188566_a((String)translation) ? new TranslationTextComponent(translation) : null);
    }
}

