/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.ProgramTable;
import net.coderbot.iris.gbuffer_overrides.matching.RenderCondition;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.gbuffer_overrides.state.RenderTargetStateListener;
import net.coderbot.iris.gl.blending.AlphaTestOverride;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.HorizonRenderer;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.world.DimensionRenderInfo;
import org.jetbrains.annotations.Nullable;

public class DeferredWorldRenderingPipeline
implements WorldRenderingPipeline,
RenderTargetStateListener {
    private final RenderTargets renderTargets;
    @Nullable
    private ShadowRenderTargets shadowRenderTargets;
    @Nullable
    private ComputeProgram[] shadowComputes;
    private final Supplier<ShadowRenderTargets> shadowTargetsSupplier;
    private final ProgramTable<Pass> table;
    private ImmutableList<ClearPass> clearPassesFull;
    private ImmutableList<ClearPass> clearPasses;
    private ImmutableList<ClearPass> shadowClearPasses;
    private ImmutableList<ClearPass> shadowClearPassesFull;
    private final CompositeRenderer prepareRenderer;
    @Nullable
    private final ShadowRenderer shadowRenderer;
    private final int shadowMapResolution;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final Texture whitePixel;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final ImmutableSet<Integer> flippedBeforeShadow;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private final HorizonRenderer horizonRenderer = new HorizonRenderer();
    private final float sunPathRotation;
    private final CloudSetting cloudSetting;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldRenderSun;
    private final boolean shouldRenderMoon;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean shouldRenderParticlesBeforeDeferred;
    private final boolean shouldRenderPrepareBeforeShadow;
    private final boolean oldLighting;
    private final boolean allowConcurrentCompute;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private Pass current = null;
    private WorldRenderingPhase overridePhase = null;
    private WorldRenderingPhase phase = WorldRenderingPhase.NONE;
    private boolean isBeforeTranslucent;
    private boolean isRenderingShadow = false;
    private InputAvailability inputs = new InputAvailability(false, false, false);
    private SpecialCondition special = null;
    private boolean shouldBindPBR;
    private int currentNormalTexture;
    private int currentSpecularTexture;
    private PackDirectives packDirectives;
    private boolean isPostChain;
    private boolean isMainBound = true;
    private boolean isRenderingWorld = false;
    private boolean isRenderingFullScreenPass = false;
    boolean sodiumTerrainRendering = false;

    public DeferredWorldRenderingPipeline(ProgramSet programs) {
        Objects.requireNonNull(programs);
        this.cloudSetting = programs.getPackDirectives().getCloudSetting();
        this.shouldRenderUnderwaterOverlay = programs.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programs.getPackDirectives().vignette();
        this.shouldRenderSun = programs.getPackDirectives().shouldRenderSun();
        this.shouldRenderMoon = programs.getPackDirectives().shouldRenderMoon();
        this.shouldWriteRainAndSnowToDepthBuffer = programs.getPackDirectives().rainDepth();
        this.shouldRenderParticlesBeforeDeferred = programs.getPackDirectives().areParticlesBeforeDeferred();
        this.allowConcurrentCompute = programs.getPackDirectives().getConcurrentCompute();
        this.shouldRenderPrepareBeforeShadow = programs.getPackDirectives().isPrepareBeforeShadow();
        this.oldLighting = programs.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        this.packDirectives = programs.getPackDirectives();
        Framebuffer mainTarget = Minecraft.func_71410_x().func_147110_a();
        int depthTextureId = mainTarget.func_242997_g();
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(depthTextureId).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        this.renderTargets = new RenderTargets(mainTarget.field_147622_a, mainTarget.field_147620_b, depthTextureId, ((Blaze3dRenderTargetExt)mainTarget).iris$getDepthBufferVersion(), depthBufferFormat, programs.getPackDirectives().getRenderTargetDirectives().getRenderTargetSettings(), programs.getPackDirectives());
        this.sunPathRotation = programs.getPackDirectives().getSunPathRotation();
        PackShadowDirectives shadowDirectives = programs.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = shadowDirectives.isDistanceRenderMulExplicit() ? ((double)shadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(shadowDirectives.getDistance() * shadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        BlockRenderingSettings.INSTANCE.setBlockStateIds(BlockMaterialMapping.createBlockStateIdMap(programs.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setBlockTypeIds(BlockMaterialMapping.createBlockTypeMap(programs.getPack().getIdMap().getBlockRenderTypeMap()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programs.getPack().getIdMap().getEntityIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programs.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programs.getPackDirectives().shouldUseSeparateAo());
        BlockRenderingSettings.INSTANCE.setUseExtendedVertexFormat(true);
        GlStateManager.func_227756_r_((int)33986);
        this.customTextureManager = new CustomTextureManager(programs.getPackDirectives(), programs.getPack().getCustomTextureDataMap(), programs.getPack().getCustomNoiseTexture());
        this.whitePixel = new NativeImageBackedSingleColorTexture(255, 255, 255, 255);
        GlStateManager.func_227756_r_((int)33984);
        this.flippedBeforeShadow = ImmutableSet.of();
        BufferFlipper flipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(() -> this.getRenderTargets().getDepthTexture(), programs.getPackDirectives().getCenterDepthHalfLife());
        this.shadowMapResolution = programs.getPackDirectives().getShadowDirectives().getResolution();
        this.shadowTargetsSupplier = () -> {
            if (this.shadowRenderTargets == null) {
                this.shadowRenderTargets = new ShadowRenderTargets(this.shadowMapResolution, shadowDirectives);
            }
            return this.shadowRenderTargets;
        };
        PatchedShaderPrinter.resetPrintState();
        this.prepareRenderer = new CompositeRenderer(programs.getPackDirectives(), programs.getPrepare(), programs.getPrepareCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.PREPARE), programs.getPackDirectives().getExplicitFlips("prepare_pre"));
        this.flippedAfterPrepare = flipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(programs.getPackDirectives(), programs.getDeferred(), programs.getDeferredCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.DEFERRED), programs.getPackDirectives().getExplicitFlips("deferred_pre"));
        this.flippedAfterTranslucent = flipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(programs.getPackDirectives(), programs.getComposite(), programs.getCompositeCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.COMPOSITE_AND_FINAL), programs.getPackDirectives().getExplicitFlips("composite_pre"));
        this.finalPassRenderer = new FinalPassRenderer(programs, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, flipper.snapshot(), this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.COMPOSITE_AND_FINAL), this.compositeRenderer.getFlippedAtLeastOnceFinal());
        ProgramId[] ids = new ProgramId[]{ProgramId.Basic, ProgramId.Textured, ProgramId.TexturedLit, ProgramId.SkyBasic, ProgramId.SkyTextured, ProgramId.SkyTextured, null, null, ProgramId.Terrain, null, null, ProgramId.Water, null, ProgramId.Clouds, ProgramId.Clouds, null, ProgramId.DamagedBlock, ProgramId.DamagedBlock, ProgramId.Block, ProgramId.Block, ProgramId.Block, ProgramId.BeaconBeam, ProgramId.BeaconBeam, ProgramId.BeaconBeam, ProgramId.Entities, ProgramId.Entities, ProgramId.Entities, ProgramId.EntitiesTrans, ProgramId.EntitiesTrans, ProgramId.EntitiesTrans, null, ProgramId.ArmorGlint, ProgramId.ArmorGlint, null, ProgramId.SpiderEyes, ProgramId.SpiderEyes, ProgramId.Hand, ProgramId.Hand, ProgramId.Hand, ProgramId.HandWater, ProgramId.HandWater, ProgramId.HandWater, null, null, ProgramId.Weather, null, ProgramId.TexturedLit, ProgramId.TexturedLit, ProgramId.Shadow, ProgramId.Shadow, ProgramId.Shadow};
        if (ids.length != RenderCondition.values().length * 3) {
            throw new IllegalStateException("Program ID table length mismatch");
        }
        ProgramFallbackResolver resolver = new ProgramFallbackResolver(programs);
        HashMap cachedPasses = new HashMap();
        this.shadowComputes = this.createShadowComputes(programs.getShadowCompute(), programs);
        this.table = new ProgramTable<Pass>((condition, availability) -> {
            int idx = availability.texture && availability.lightmap ? 2 : (availability.texture ? 1 : 0);
            ProgramId id = ids[condition.ordinal() * 3 + idx];
            if (id == null) {
                id = ids[idx];
            }
            ProgramId finalId = id;
            return cachedPasses.computeIfAbsent(new Pair((Object)id, availability), p -> {
                ProgramSource source = resolver.resolveNullable((ProgramId)((Object)((Object)((Object)p.getFirst()))));
                if (condition == RenderCondition.SHADOW) {
                    if (!shadowDirectives.isShadowEnabled().orElse(this.shadowRenderTargets != null)) {
                        return null;
                    }
                    if (source == null) {
                        GlFramebuffer shadowFb = this.shadowTargetsSupplier.get().createShadowFramebuffer(this.shadowRenderTargets.snapshot(), new int[]{0});
                        return new Pass(null, shadowFb, shadowFb, null, BlendModeOverride.OFF, Collections.emptyList(), true);
                    }
                }
                if (source == null) {
                    return this.createDefaultPass();
                }
                try {
                    return this.createPass(source, (InputAvailability)availability, condition == RenderCondition.SHADOW, finalId);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create pass for " + source.getName() + " for rendering condition " + (Object)condition + " specialized to input availability " + availability, e);
                }
            });
        });
        if (this.shadowRenderTargets == null && shadowDirectives.isShadowEnabled() == OptionalBoolean.TRUE) {
            this.shadowRenderTargets = new ShadowRenderTargets(this.shadowMapResolution, shadowDirectives);
        }
        if (this.shadowRenderTargets != null) {
            this.shadowClearPasses = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, false, shadowDirectives);
            this.shadowClearPassesFull = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, true, shadowDirectives);
            if (programs.getPackDirectives().getShadowDirectives().isShadowEnabled().orElse(true)) {
                this.shadowRenderer = new ShadowRenderer(programs.getShadow().orElse(null), programs.getPackDirectives(), this.shadowRenderTargets);
                Program shadowProgram = this.table.match(RenderCondition.SHADOW, new InputAvailability(true, true, true)).getProgram();
                this.shadowRenderer.setUsesImages(shadowProgram != null && shadowProgram.getActiveImages() > 0);
            } else {
                this.shadowRenderer = null;
            }
        } else {
            this.shadowClearPasses = ImmutableList.of();
            this.shadowClearPassesFull = ImmutableList.of();
            this.shadowRenderer = null;
        }
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programs.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programs.getPackDirectives().getRenderTargetDirectives());
        Supplier<ImmutableSet> flipped = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> createTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.GBUFFERS_AND_SHADOW));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> createShadowTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.GBUFFERS_AND_SHADOW));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> this.flippedAfterPrepare, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createShadowTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, () -> this.flippedAfterPrepare, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(this, programs, createTerrainSamplers, this.shadowRenderer == null ? null : createShadowTerrainSamplers, createTerrainImages, this.shadowRenderer == null ? null : createShadowTerrainImages);
    }

    private RenderTargets getRenderTargets() {
        return this.renderTargets;
    }

    private void checkWorld() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            this.isRenderingWorld = false;
            this.current = null;
        }
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowRenderer != null;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldRenderSun() {
        return this.shouldRenderSun;
    }

    @Override
    public boolean shouldRenderMoon() {
        return this.shouldRenderMoon;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public boolean shouldRenderParticlesBeforeDeferred() {
        return this.shouldRenderParticlesBeforeDeferred;
    }

    @Override
    public boolean allowConcurrentCompute() {
        return this.allowConcurrentCompute;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    private RenderCondition getCondition(WorldRenderingPhase phase) {
        if (this.isRenderingShadow) {
            return RenderCondition.SHADOW;
        }
        if (this.special != null) {
            if (this.special == SpecialCondition.BEACON_BEAM) {
                return RenderCondition.BEACON_BEAM;
            }
            if (this.special == SpecialCondition.ENTITY_EYES) {
                return RenderCondition.ENTITY_EYES;
            }
            if (this.special == SpecialCondition.GLINT) {
                return RenderCondition.GLINT;
            }
        }
        switch (phase) {
            case NONE: 
            case OUTLINE: 
            case DEBUG: 
            case PARTICLES: {
                return RenderCondition.DEFAULT;
            }
            case SKY: 
            case SUNSET: 
            case CUSTOM_SKY: 
            case SUN: 
            case MOON: 
            case STARS: 
            case VOID: {
                return RenderCondition.SKY;
            }
            case TERRAIN_SOLID: 
            case TERRAIN_CUTOUT: 
            case TERRAIN_CUTOUT_MIPPED: {
                return RenderCondition.TERRAIN_OPAQUE;
            }
            case ENTITIES: {
                if (GlStateManagerAccessor.getBLEND().field_179211_b == GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_ && GlStateManagerAccessor.getBLEND().field_179212_c == GlStateManager.SourceFactor.ONE_MINUS_SRC_ALPHA.field_225655_p_ && GlStateManagerAccessor.getBLEND().field_179209_d == GlStateManager.SourceFactor.ONE.field_225655_p_ && GlStateManagerAccessor.getBLEND().field_179210_e == GlStateManager.SourceFactor.ONE_MINUS_SRC_ALPHA.field_225655_p_) {
                    return RenderCondition.ENTITIES_TRANSLUCENT;
                }
                return RenderCondition.ENTITIES;
            }
            case BLOCK_ENTITIES: {
                return RenderCondition.BLOCK_ENTITIES;
            }
            case DESTROY: {
                return RenderCondition.DESTROY;
            }
            case HAND_SOLID: {
                return RenderCondition.HAND_OPAQUE;
            }
            case TERRAIN_TRANSLUCENT: 
            case TRIPWIRE: {
                return RenderCondition.TERRAIN_TRANSLUCENT;
            }
            case CLOUDS: {
                return RenderCondition.CLOUDS;
            }
            case RAIN_SNOW: {
                return RenderCondition.RAIN_SNOW;
            }
            case HAND_TRANSLUCENT: {
                return RenderCondition.HAND_TRANSLUCENT;
            }
            case WORLD_BORDER: {
                return RenderCondition.WORLD_BORDER;
            }
        }
        throw new IllegalStateException("Unknown render phase " + (Object)((Object)phase));
    }

    private void matchPass() {
        if (!this.isRenderingWorld || this.isRenderingFullScreenPass || this.isPostChain || !this.isMainBound) {
            return;
        }
        if (this.sodiumTerrainRendering) {
            this.beginPass(this.table.match(this.getCondition(this.getPhase()), new InputAvailability(true, true, false)));
            return;
        }
        this.beginPass(this.table.match(this.getCondition(this.getPhase()), this.inputs));
    }

    public void beginPass(Pass pass) {
        if (this.current == pass) {
            return;
        }
        if (this.current != null) {
            this.current.stopUsing();
        }
        this.current = pass;
        if (pass != null) {
            pass.use();
        } else {
            Program.unbind();
        }
    }

    private Pass createDefaultPass() {
        GlFramebuffer framebufferBeforeTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, new int[]{0});
        GlFramebuffer framebufferAfterTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, new int[]{0});
        return new Pass(null, framebufferBeforeTranslucents, framebufferAfterTranslucents, null, null, Collections.emptyList(), false);
    }

    private Pass createPass(ProgramSource source, InputAvailability availability, boolean shadow, ProgramId id) {
        Map<PatchShaderType, String> transformed = TransformPatcher.patchAttributes(source.getVertexSource().orElseThrow(NullPointerException::new), source.getGeometrySource().orElse(null), source.getFragmentSource().orElseThrow(NullPointerException::new), availability);
        String vertex = transformed.get((Object)PatchShaderType.VERTEX);
        String geometry = transformed.get((Object)PatchShaderType.GEOMETRY);
        String fragment = transformed.get((Object)PatchShaderType.FRAGMENT);
        PatchedShaderPrinter.debugPatchedShaders(source.getName(), vertex, geometry, fragment);
        ProgramBuilder builder = ProgramBuilder.begin(source.getName(), vertex, geometry, fragment, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        return this.createPassInner(builder, source.getParent().getPack().getIdMap(), source.getDirectives(), source.getParent().getPackDirectives(), availability, shadow, id);
    }

    private Pass createPassInner(ProgramBuilder builder, IdMap map, ProgramDirectives programDirectives, PackDirectives packDirectives, InputAvailability availability, boolean shadow, ProgramId id) {
        GlFramebuffer framebufferAfterTranslucents;
        GlFramebuffer framebufferBeforeTranslucents;
        CommonUniforms.addCommonUniforms(builder, map, packDirectives, this.updateNotifier);
        Supplier<Object> flipped = shadow ? () -> this.shouldRenderPrepareBeforeShadow ? this.flippedAfterPrepare : this.flippedBeforeShadow : () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(textureStage));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
        IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
        if (!this.shouldBindPBR) {
            this.shouldBindPBR = IrisSamplers.hasPBRSamplers(customTextureSamplerInterceptor);
        }
        IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, availability);
        if (!shadow) {
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        }
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            if (!shadow) {
                this.shadowTargetsSupplier.get();
            }
            if (this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets);
                IrisImages.addShadowColorImages(builder, this.shadowRenderTargets);
            }
        }
        if (shadow) {
            framebufferAfterTranslucents = framebufferBeforeTranslucents = this.shadowTargetsSupplier.get().createShadowFramebuffer(this.shadowRenderTargets.snapshot(), new int[]{0, 1});
        } else {
            framebufferBeforeTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, programDirectives.getDrawBuffers());
            framebufferAfterTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, programDirectives.getDrawBuffers());
        }
        builder.bindAttributeLocation(11, "mc_Entity");
        builder.bindAttributeLocation(12, "mc_midTexCoord");
        builder.bindAttributeLocation(13, "at_tangent");
        builder.bindAttributeLocation(14, "at_midBlock");
        AlphaTestOverride alphaTestOverride = programDirectives.getAlphaTestOverride().orElse(null);
        ArrayList bufferOverrides = new ArrayList();
        programDirectives.getBufferBlendOverrides().forEach(information -> {
            int index = Ints.indexOf((int[])programDirectives.getDrawBuffers(), (int)information.getIndex());
            if (index > -1) {
                bufferOverrides.add(new BufferBlendOverride(index, information.getBlendMode()));
            }
        });
        return new Pass(builder.build(), framebufferBeforeTranslucents, framebufferAfterTranslucents, alphaTestOverride, programDirectives.getBlendModeOverride().orElse(id.getBlendModeOverride()), bufferOverrides, shadow);
    }

    @Override
    public void beginPostChain() {
        this.isPostChain = true;
        this.beginPass(null);
    }

    @Override
    public void endPostChain() {
        this.isPostChain = false;
    }

    @Override
    public void setIsMainBound(boolean bound) {
        this.isMainBound = bound;
        if (!this.isRenderingWorld || this.isRenderingFullScreenPass || this.isPostChain) {
            return;
        }
        if (bound) {
            this.current = null;
        } else {
            this.beginPass(null);
        }
    }

    @Override
    public void destroy() {
        BlendModeOverride.restore();
        AlphaTestOverride.restore();
        DeferredWorldRenderingPipeline.destroyPasses(this.table);
        this.compositeRenderer.destroy();
        this.deferredRenderer.destroy();
        this.finalPassRenderer.destroy();
        this.centerDepthSampler.destroy();
        this.horizonRenderer.destroy();
        GlStateManager.func_227727_h_((int)36008, (int)0);
        GlStateManager.func_227727_h_((int)36009, (int)0);
        GlStateManager.func_227727_h_((int)36160, (int)0);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        this.renderTargets.destroy();
        if (this.shadowRenderTargets != null) {
            this.shadowRenderTargets.destroy();
        }
        this.customTextureManager.destroy();
        this.whitePixel.func_147631_c();
    }

    private static void destroyPasses(ProgramTable<Pass> table) {
        HashSet destroyed = new HashSet();
        table.forEach(pass -> {
            if (pass == null) {
                return;
            }
            if (destroyed.contains(pass)) {
                return;
            }
            pass.destroy();
            destroyed.add(pass);
        });
    }

    private void prepareRenderTargets() {
        ImmutableList<ClearPass> passes;
        RenderSystem.activeTexture((int)33984);
        Vector4f emptyClearColor = new Vector4f(1.0f);
        if (this.shadowRenderTargets != null) {
            if (this.packDirectives.getShadowDirectives().isShadowEnabled() == OptionalBoolean.FALSE) {
                if (this.shadowRenderTargets.isFullClearRequired()) {
                    this.shadowRenderTargets.onFullClear();
                    for (Object clearPass2 : this.shadowClearPassesFull) {
                        ((ClearPass)clearPass2).execute(emptyClearColor);
                    }
                }
            } else {
                ImmutableList<ClearPass> passes2;
                this.shadowRenderTargets.getDepthSourceFb().bind();
                RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
                for (ComputeProgram computeProgram : this.shadowComputes) {
                    if (computeProgram == null) continue;
                    computeProgram.dispatch(this.shadowMapResolution, this.shadowMapResolution);
                }
                if (this.shadowRenderTargets.isFullClearRequired()) {
                    passes2 = this.shadowClearPassesFull;
                    this.shadowRenderTargets.onFullClear();
                } else {
                    passes2 = this.shadowClearPasses;
                }
                for (ClearPass clearPass3 : passes2) {
                    clearPass3.execute(emptyClearColor);
                }
            }
        }
        Framebuffer main = Minecraft.func_71410_x().func_147110_a();
        Blaze3dRenderTargetExt mainExt = (Blaze3dRenderTargetExt)main;
        int depthTextureId = main.func_242997_g();
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(depthTextureId).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        boolean changed = this.renderTargets.resizeIfNeeded(mainExt.iris$getDepthBufferVersion(), depthTextureId, main.field_147622_a, main.field_147620_b, depthBufferFormat, this.packDirectives);
        if (changed) {
            this.prepareRenderer.recalculateSizes();
            this.deferredRenderer.recalculateSizes();
            this.compositeRenderer.recalculateSizes();
            this.finalPassRenderer.recalculateSwapPassSize();
            this.clearPassesFull.forEach(clearPass -> this.renderTargets.destroyFramebuffer(clearPass.getFramebuffer()));
            this.clearPasses.forEach(clearPass -> this.renderTargets.destroyFramebuffer(clearPass.getFramebuffer()));
            this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, this.packDirectives.getRenderTargetDirectives());
            this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, this.packDirectives.getRenderTargetDirectives());
        }
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            passes = this.clearPassesFull;
        } else {
            passes = this.clearPasses;
        }
        Vector3d fogColor3 = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f fogColor = new Vector4f((float)fogColor3.x, (float)fogColor3.y, (float)fogColor3.z, 1.0f);
        for (ClearPass clearPass4 : passes) {
            clearPass4.execute(fogColor);
        }
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
    }

    private ComputeProgram[] createShadowComputes(ComputeSource[] compute, ProgramSet programSet) {
        ComputeProgram[] programs = new ComputeProgram[compute.length];
        for (int i = 0; i < programs.length; ++i) {
            ProgramBuilder builder;
            ComputeSource source = compute[i];
            if (source == null || !source.getSource().isPresent()) continue;
            try {
                builder = ProgramBuilder.beginCompute(source.getName(), source.getSource().orElse(null), IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Shader compilation failed!", e);
            }
            CommonUniforms.addCommonUniforms(builder, programSet.getPack().getIdMap(), programSet.getPackDirectives(), this.updateNotifier);
            Supplier<ImmutableSet<Integer>> flipped = () -> this.flippedBeforeShadow;
            TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(textureStage));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
            IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets);
                IrisImages.addShadowColorImages(builder, this.shadowRenderTargets);
            }
            programs[i] = builder.buildCompute();
            programs[i].setWorkGroupInfo(source.getWorkGroupRelative(), source.getWorkGroups());
        }
        return programs;
    }

    @Override
    public void beginHand() {
        this.renderTargets.copyPreHandDepth();
    }

    @Override
    public void beginTranslucents() {
        this.isBeforeTranslucent = false;
        this.renderTargets.copyPreTranslucentDepth();
        this.beginPass(null);
        this.isRenderingFullScreenPass = true;
        this.deferredRenderer.renderAll();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public void renderShadows(LevelRendererAccessor levelRenderer, ActiveRenderInfo playerCamera) {
        if (this.shouldRenderPrepareBeforeShadow) {
            this.isRenderingFullScreenPass = true;
            this.prepareRenderer.renderAll();
            this.isRenderingFullScreenPass = false;
        }
        if (this.shadowRenderer != null) {
            this.isRenderingShadow = true;
            this.shadowRenderer.renderShadows(levelRenderer, playerCamera);
            this.beginPass(null);
            this.isRenderingShadow = false;
        }
        if (!this.shouldRenderPrepareBeforeShadow) {
            this.isRenderingFullScreenPass = true;
            this.prepareRenderer.renderAll();
            this.isRenderingFullScreenPass = false;
        }
    }

    @Override
    public void addDebugText(List<String> messages) {
        messages.add("");
        if (this.shadowRenderer != null) {
            this.shadowRenderer.addDebugText(messages);
        } else {
            messages.add("[Iris] Shadow Maps: not used by shader pack");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginLevelRendering() {
        this.isRenderingFullScreenPass = false;
        this.isRenderingWorld = true;
        this.isBeforeTranslucent = true;
        this.isMainBound = true;
        this.isPostChain = false;
        this.phase = WorldRenderingPhase.NONE;
        this.overridePhase = null;
        HandRenderer.INSTANCE.getBufferSource().resetDrawCalls();
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("beginWorldRender was called but we are not currently rendering a world?");
            return;
        }
        if (this.current != null) {
            throw new IllegalStateException("Called beginLevelRendering but level rendering appears to still be in progress?");
        }
        this.updateNotifier.onNewFrame();
        this.prepareRenderTargets();
        this.setPhase(WorldRenderingPhase.SKY);
        DimensionRenderInfo.FogType skyType = Minecraft.func_71410_x().field_71441_e.func_239132_a_().func_241683_c_();
        if (skyType == DimensionRenderInfo.FogType.NORMAL) {
            RenderSystem.disableTexture();
            RenderSystem.depthMask((boolean)false);
            Vector3d fogColor = CapturedRenderingState.INSTANCE.getFogColor();
            RenderSystem.color3f((float)((float)fogColor.x), (float)((float)fogColor.y), (float)((float)fogColor.z));
            this.horizonRenderer.renderHorizon(CapturedRenderingState.INSTANCE.getGbufferModelView());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableTexture();
        }
    }

    @Override
    public void finalizeLevelRendering() {
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("finalizeWorldRendering was called but we are not currently rendering a world?");
            return;
        }
        this.beginPass(null);
        this.isRenderingWorld = false;
        this.phase = WorldRenderingPhase.NONE;
        this.overridePhase = null;
        this.isRenderingFullScreenPass = true;
        this.centerDepthSampler.sampleCenterDepth();
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public WorldRenderingPhase getPhase() {
        if (this.overridePhase != null) {
            return this.overridePhase;
        }
        return this.phase;
    }

    @Override
    public void syncProgram() {
        this.matchPass();
    }

    @Override
    public void beginSodiumTerrainRendering() {
        this.sodiumTerrainRendering = true;
        this.syncProgram();
    }

    @Override
    public void endSodiumTerrainRendering() {
        this.sodiumTerrainRendering = false;
        this.current = null;
        this.syncProgram();
    }

    @Override
    public void setOverridePhase(WorldRenderingPhase phase) {
        this.overridePhase = phase;
        GbufferPrograms.runPhaseChangeNotifier();
    }

    @Override
    public void setPhase(WorldRenderingPhase phase) {
        this.phase = phase;
        GbufferPrograms.runPhaseChangeNotifier();
    }

    @Override
    public void setInputs(InputAvailability availability) {
        this.inputs = availability;
    }

    @Override
    public void setSpecialCondition(SpecialCondition special) {
        this.special = special;
    }

    @Override
    public RenderTargetStateListener getRenderTargetStateListener() {
        return this;
    }

    @Override
    public int getCurrentNormalTexture() {
        return this.currentNormalTexture;
    }

    @Override
    public int getCurrentSpecularTexture() {
        return this.currentSpecularTexture;
    }

    @Override
    public void onBindTexture(int id) {
        if (this.shouldBindPBR && this.isRenderingWorld) {
            PBRTextureHolder pbrHolder = PBRTextureManager.INSTANCE.getOrLoadHolder(id);
            this.currentNormalTexture = pbrHolder.getNormalTexture().func_110552_b();
            this.currentSpecularTexture = pbrHolder.getSpecularTexture().func_110552_b();
            TextureFormat textureFormat = TextureFormatLoader.getFormat();
            if (textureFormat != null) {
                textureFormat.setupTextureParameters(PBRType.NORMAL, pbrHolder.getNormalTexture());
                textureFormat.setupTextureParameters(PBRType.SPECULAR, pbrHolder.getSpecularTexture());
            }
            PBRTextureManager.notifyPBRTexturesChanged();
        }
    }

    private final class Pass {
        @Nullable
        private final Program program;
        private final GlFramebuffer framebufferBeforeTranslucents;
        private final GlFramebuffer framebufferAfterTranslucents;
        @Nullable
        private final AlphaTestOverride alphaTestOverride;
        @Nullable
        private final BlendModeOverride blendModeOverride;
        @Nullable
        private final List<BufferBlendOverride> bufferBlendOverrides;
        private final boolean shadowViewport;

        private Pass(Program program, GlFramebuffer framebufferBeforeTranslucents, @Nullable GlFramebuffer framebufferAfterTranslucents, @Nullable AlphaTestOverride alphaTestOverride, @Nullable BlendModeOverride blendModeOverride, List<BufferBlendOverride> bufferBlendOverrides, boolean shadowViewport) {
            this.program = program;
            this.framebufferBeforeTranslucents = framebufferBeforeTranslucents;
            this.framebufferAfterTranslucents = framebufferAfterTranslucents;
            this.alphaTestOverride = alphaTestOverride;
            this.blendModeOverride = blendModeOverride;
            this.bufferBlendOverrides = bufferBlendOverrides;
            this.shadowViewport = shadowViewport;
        }

        public void use() {
            if (DeferredWorldRenderingPipeline.this.isBeforeTranslucent) {
                this.framebufferBeforeTranslucents.bind();
            } else {
                this.framebufferAfterTranslucents.bind();
            }
            if (this.shadowViewport) {
                RenderSystem.viewport((int)0, (int)0, (int)DeferredWorldRenderingPipeline.this.shadowMapResolution, (int)DeferredWorldRenderingPipeline.this.shadowMapResolution);
            } else {
                Framebuffer main = Minecraft.func_71410_x().func_147110_a();
                RenderSystem.viewport((int)0, (int)0, (int)main.field_147622_a, (int)main.field_147620_b);
            }
            if (this.program != null && !DeferredWorldRenderingPipeline.this.sodiumTerrainRendering) {
                this.program.use();
            }
            if (this.alphaTestOverride != null) {
                this.alphaTestOverride.apply();
            } else {
                AlphaTestOverride.restore();
            }
            if (this.blendModeOverride != null) {
                this.blendModeOverride.apply();
            } else {
                BlendModeOverride.restore();
            }
            if (this.bufferBlendOverrides != null && !this.bufferBlendOverrides.isEmpty()) {
                this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
            }
        }

        public void stopUsing() {
            if (this.alphaTestOverride != null) {
                AlphaTestOverride.restore();
            }
            if (this.blendModeOverride != null || this.bufferBlendOverrides != null && !this.bufferBlendOverrides.isEmpty()) {
                BlendModeOverride.restore();
            }
        }

        @Nullable
        public Program getProgram() {
            return this.program;
        }

        public void destroy() {
            if (this.program != null) {
                this.program.destroy();
            }
        }
    }
}

