/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.pipeline.FixedFunctionWorldRenderingPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;

public class PipelineManager {
    private static PipelineManager instance;
    private final Function<DimensionId, WorldRenderingPipeline> pipelineFactory;
    private final Map<DimensionId, WorldRenderingPipeline> pipelinesPerDimension = new HashMap<DimensionId, WorldRenderingPipeline>();
    private WorldRenderingPipeline pipeline = new FixedFunctionWorldRenderingPipeline();
    private int versionCounterForSodiumShaderReload = 0;

    public PipelineManager(Function<DimensionId, WorldRenderingPipeline> pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    public WorldRenderingPipeline preparePipeline(DimensionId currentDimension) {
        if (!this.pipelinesPerDimension.containsKey((Object)currentDimension)) {
            SystemTimeUniforms.COUNTER.reset();
            SystemTimeUniforms.TIMER.reset();
            Iris.logger.info("Creating pipeline for dimension {}", new Object[]{currentDimension});
            this.pipeline = this.pipelineFactory.apply(currentDimension);
            this.pipelinesPerDimension.put(currentDimension, this.pipeline);
            if (BlockRenderingSettings.INSTANCE.isReloadRequired()) {
                if (Minecraft.func_71410_x().field_71438_f != null) {
                    Minecraft.func_71410_x().field_71438_f.func_72712_a();
                }
                BlockRenderingSettings.INSTANCE.clearReloadRequired();
            }
        } else {
            this.pipeline = this.pipelinesPerDimension.get((Object)currentDimension);
        }
        return this.pipeline;
    }

    @Nullable
    public WorldRenderingPipeline getPipelineNullable() {
        return this.pipeline;
    }

    public Optional<WorldRenderingPipeline> getPipeline() {
        return Optional.ofNullable(this.pipeline);
    }

    public int getVersionCounterForSodiumShaderReload() {
        return this.versionCounterForSodiumShaderReload;
    }

    public void destroyPipeline() {
        this.pipelinesPerDimension.forEach((dimensionId, pipeline) -> {
            Iris.logger.info("Destroying pipeline {}", dimensionId);
            this.resetTextureState();
            pipeline.destroy();
        });
        this.pipelinesPerDimension.clear();
        this.pipeline = null;
        ++this.versionCounterForSodiumShaderReload;
    }

    private void resetTextureState() {
        for (int i = 0; i < 16; ++i) {
            GlStateManager.func_227744_n_((int)(33984 + i));
            GlStateManager.func_227760_t_((int)0);
        }
        GlStateManager.func_227744_n_((int)33984);
    }
}

