/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.client.renderer.texture.Texture;
import org.jetbrains.annotations.Nullable;

public class TextureTracker {
    public static final TextureTracker INSTANCE = new TextureTracker();
    private static Runnable bindTextureListener;
    private final Int2ObjectMap<Texture> textures = new Int2ObjectOpenHashMap();
    private boolean lockBindCallback;

    private TextureTracker() {
    }

    public void trackTexture(int id, Texture texture) {
        this.textures.put(id, (Object)texture);
    }

    @Nullable
    public Texture getTexture(int id) {
        return (Texture)this.textures.get(id);
    }

    public void onBindTexture(int id) {
        if (this.lockBindCallback) {
            return;
        }
        if (GlStateManagerAccessor.getActiveTexture() == 0) {
            WorldRenderingPipeline pipeline;
            this.lockBindCallback = true;
            if (bindTextureListener != null) {
                bindTextureListener.run();
            }
            if ((pipeline = Iris.getPipelineManager().getPipelineNullable()) != null) {
                pipeline.onBindTexture(id);
            }
            IrisRenderSystem.bindTextureToUnit(0, id);
            this.lockBindCallback = false;
        }
    }

    public void onDeleteTexture(int id) {
        this.textures.remove(id);
    }

    static {
        StateUpdateNotifiers.bindTextureNotifier = listener -> {
            bindTextureListener = listener;
        };
    }
}

