/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.util.Objects;
import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public final class CelestialUniforms {
    private final float sunPathRotation;

    public CelestialUniforms(float sunPathRotation) {
        this.sunPathRotation = sunPathRotation;
    }

    public void addCelestialUniforms(UniformHolder uniforms) {
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "sunAngle", CelestialUniforms::getSunAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "sunPosition", this::getSunPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "moonPosition", this::getMoonPosition).uniform1f(UniformUpdateFrequency.PER_FRAME, "shadowAngle", CelestialUniforms::getShadowAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "shadowLightPosition", this::getShadowLightPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "upPosition", CelestialUniforms::getUpPosition);
    }

    public static float getSunAngle() {
        float skyAngle = CelestialUniforms.getSkyAngle();
        if (skyAngle < 0.75f) {
            return skyAngle + 0.25f;
        }
        return skyAngle - 0.75f;
    }

    private static float getShadowAngle() {
        float shadowAngle = CelestialUniforms.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            shadowAngle -= 0.5f;
        }
        return shadowAngle;
    }

    private Vector4f getSunPosition() {
        return this.getCelestialPosition(100.0f);
    }

    private Vector4f getMoonPosition() {
        return this.getCelestialPosition(-100.0f);
    }

    public Vector4f getShadowLightPosition() {
        return CelestialUniforms.isDay() ? this.getSunPosition() : this.getMoonPosition();
    }

    public Vector4f getShadowLightPositionInWorldSpace() {
        return CelestialUniforms.isDay() ? this.getCelestialPositionInWorldSpace(100.0f) : this.getCelestialPositionInWorldSpace(-100.0f);
    }

    private Vector4f getCelestialPositionInWorldSpace(float y) {
        net.minecraft.util.math.vector.Vector4f position = new net.minecraft.util.math.vector.Vector4f(0.0f, y, 0.0f, 0.0f);
        Matrix4f celestial = new Matrix4f();
        celestial.func_226591_a_();
        celestial.func_226596_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        celestial.func_226596_a_(Vector3f.field_229183_f_.func_229187_a_(this.sunPathRotation));
        celestial.func_226596_a_(Vector3f.field_229179_b_.func_229187_a_(CelestialUniforms.getSkyAngle() * 360.0f));
        position.func_229372_a_(celestial);
        return JomlConversions.toJoml(position);
    }

    private Vector4f getCelestialPosition(float y) {
        net.minecraft.util.math.vector.Vector4f position = new net.minecraft.util.math.vector.Vector4f(0.0f, y, 0.0f, 0.0f);
        Matrix4f celestial = CapturedRenderingState.INSTANCE.getGbufferModelView().func_226601_d_();
        celestial.func_226596_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        celestial.func_226596_a_(Vector3f.field_229183_f_.func_229187_a_(this.sunPathRotation));
        celestial.func_226596_a_(Vector3f.field_229179_b_.func_229187_a_(CelestialUniforms.getSkyAngle() * 360.0f));
        position.func_229372_a_(celestial);
        return JomlConversions.toJoml(position);
    }

    private static Vector4f getUpPosition() {
        net.minecraft.util.math.vector.Vector4f upVector = new net.minecraft.util.math.vector.Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f preCelestial = CapturedRenderingState.INSTANCE.getGbufferModelView().func_226601_d_();
        preCelestial.func_226596_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        upVector.func_229372_a_(preCelestial);
        return JomlConversions.toJoml(upVector);
    }

    public static boolean isDay() {
        return (double)CelestialUniforms.getSunAngle() <= 0.5;
    }

    private static ClientWorld getWorld() {
        return Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
    }

    private static float getSkyAngle() {
        return CelestialUniforms.getWorld().func_242415_f(CapturedRenderingState.INSTANCE.getTickDelta());
    }
}

