/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.bloomfilter;

import java.util.function.LongPredicate;
import repack.apache.commons.collections4.bloomfilter.LongBiPredicate;

class CountingLongPredicate
implements LongPredicate {
    private int idx = 0;
    private final long[] ary;
    private final LongBiPredicate func;

    CountingLongPredicate(long[] ary, LongBiPredicate func) {
        this.ary = ary;
        this.func = func;
    }

    @Override
    public boolean test(long other) {
        return this.func.test(this.idx == this.ary.length ? 0L : this.ary[this.idx++], other);
    }

    boolean forEachRemaining() {
        int i;
        long[] a = this.ary;
        int limit = a.length;
        for (i = this.idx; i != limit && this.func.test(a[i], 0L); ++i) {
        }
        return i == limit;
    }
}

