/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.change.changes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.change.changes.IChange;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.change.changes.BitChange;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.Validate;

public class CombinedChange
implements IChange {
    private final Collection<IChange> changes;

    public CombinedChange(Collection<IChange> changes) {
        this.changes = changes;
    }

    public CombinedChange(INBT tag) {
        Validate.isInstanceOf(CompoundNBT.class, (Object)tag);
        this.changes = new ArrayList<IChange>();
        this.deserializeNBT((CompoundNBT)tag);
    }

    @Override
    public boolean canUndo(PlayerEntity player) {
        for (IChange change : this.changes) {
            if (change.canUndo(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canRedo(PlayerEntity player) {
        for (IChange change : this.changes) {
            if (change.canRedo(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void undo(PlayerEntity player) throws IllegalChangeAttempt {
        for (IChange change : this.changes) {
            change.undo(player);
        }
    }

    @Override
    public void redo(PlayerEntity player) throws IllegalChangeAttempt {
        for (IChange change : this.changes) {
            change.redo(player);
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("changes", (INBT)this.changes.stream().map(INBTSerializable::serializeNBT).collect(Collectors.toCollection(ListNBT::new)));
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT tag = nbt.func_150295_c("changes", 10);
        this.changes.clear();
        this.changes.addAll(tag.stream().map(BitChange::new).collect(Collectors.toList()));
    }
}

