/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.metadata.IMetadataKey;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.item.chisel.IChiselingItem;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class ChiselingContext
implements IChiselingContext {
    private final IWorld world;
    private final IChiselMode chiselMode;
    private final ChiselingOperation modeOfOperandus;
    private final boolean simulation;
    private final Runnable onCompleteCallback;
    private final ItemStack causingItemStack;
    private final boolean supportsDamaging;
    private final PlayerEntity playerEntity;
    private boolean complete = false;
    private IWorldAreaMutator mutator = null;
    private Function<IAreaAccessor, Predicate<IStateEntryInfo>> filterBuilder = null;
    private Map<IMetadataKey<?>, Object> metadataKeyMap = Maps.newHashMap();

    public ChiselingContext(IWorld world, IChiselMode chiselMode, ChiselingOperation modeOfOperandus, boolean simulation, Runnable onCompleteCallback, ItemStack causingItemStack, PlayerEntity playerEntity) {
        this.world = world;
        this.chiselMode = chiselMode;
        this.simulation = simulation;
        this.onCompleteCallback = onCompleteCallback;
        this.modeOfOperandus = modeOfOperandus;
        this.causingItemStack = causingItemStack;
        this.supportsDamaging = this.causingItemStack.func_77973_b() instanceof IChiselingItem ? ((IChiselingItem)this.causingItemStack.func_77973_b()).isDamageableDuringChiseling() : false;
        this.playerEntity = playerEntity;
    }

    private ChiselingContext(IWorld world, IChiselMode chiselMode, ChiselingOperation modeOfOperandus, boolean complete, IWorldAreaMutator mutator, PlayerEntity playerEntity) {
        this.world = world;
        this.chiselMode = chiselMode;
        this.causingItemStack = ItemStack.field_190927_a;
        this.supportsDamaging = false;
        this.onCompleteCallback = () -> {};
        this.simulation = true;
        this.modeOfOperandus = modeOfOperandus;
        this.complete = complete;
        this.mutator = mutator;
        this.playerEntity = playerEntity;
    }

    private ChiselingContext(IWorld world, IChiselMode chiselMode, ChiselingOperation modeOfOperandus, boolean complete, PlayerEntity playerEntity) {
        this.world = world;
        this.chiselMode = chiselMode;
        this.causingItemStack = ItemStack.field_190927_a;
        this.supportsDamaging = false;
        this.onCompleteCallback = () -> {};
        this.simulation = true;
        this.modeOfOperandus = modeOfOperandus;
        this.complete = complete;
        this.playerEntity = playerEntity;
    }

    private void setMetadataKeyMap(Map<IMetadataKey<?>, Object> metadataKeyMap) {
        this.metadataKeyMap = metadataKeyMap;
    }

    @Override
    @NotNull
    public Optional<IWorldAreaMutator> getMutator() {
        if (this.mutator == null || this.playerEntity == null || !(this.world instanceof World)) {
            return Optional.ofNullable(this.mutator);
        }
        if (BlockPosStreamProvider.getForRange(this.mutator.getInWorldStartPoint(), this.mutator.getInWorldEndPoint()).anyMatch(position -> {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((World)this.world, position, this.world.func_180495_p(position), this.playerEntity);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.isCanceled();
        })) {
            this.mutator = null;
            return Optional.empty();
        }
        return Optional.of(this.mutator);
    }

    @Override
    @NotNull
    public IWorld getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public IChiselMode getMode() {
        return this.chiselMode;
    }

    @Override
    @NotNull
    public IChiselingContext include(Vector3d worldPosition) {
        if (this.getMutator().map(m -> !m.isInside(worldPosition)).orElse(true).booleanValue()) {
            if (this.getMutator().isPresent()) {
                IWorldAreaMutator worldAreaMutator = this.getMutator().get();
                Vector3d start = new Vector3d(Math.min(worldPosition.func_82615_a(), worldAreaMutator.getInWorldStartPoint().func_82615_a()), Math.min(worldPosition.func_82617_b(), worldAreaMutator.getInWorldStartPoint().func_82617_b()), Math.min(worldPosition.func_82616_c(), worldAreaMutator.getInWorldStartPoint().func_82616_c()));
                Vector3d end = new Vector3d(Math.max(worldPosition.func_82615_a(), worldAreaMutator.getInWorldEndPoint().func_82615_a()), Math.max(worldPosition.func_82617_b(), worldAreaMutator.getInWorldEndPoint().func_82617_b()), Math.max(worldPosition.func_82616_c(), worldAreaMutator.getInWorldEndPoint().func_82616_c()));
                this.mutator = IMutatorFactory.getInstance().covering(this.world, start, end);
            } else {
                this.mutator = IMutatorFactory.getInstance().covering(this.world, worldPosition, worldPosition);
            }
        }
        return this;
    }

    @Override
    public void setComplete() {
        this.complete = true;
        this.onCompleteCallback.run();
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isSimulation() {
        return this.simulation;
    }

    @Override
    @NotNull
    public ChiselingOperation getModeOfOperandus() {
        return this.modeOfOperandus;
    }

    @Override
    @NotNull
    public IChiselingContext createSnapshot() {
        ChiselingContext context = this.createInnerSnapshot();
        HashMap newMetadata = Maps.newHashMap();
        for (IMetadataKey<?> key : this.metadataKeyMap.keySet()) {
            Optional<?> value = this.snapshotMetadata(key);
            value.ifPresent(o -> newMetadata.put(key, o));
        }
        context.setMetadataKeyMap(newMetadata);
        return context;
    }

    @NotNull
    private ChiselingContext createInnerSnapshot() {
        if (this.mutator == null) {
            return new ChiselingContext(this.world, this.chiselMode, this.modeOfOperandus, this.complete, this.playerEntity);
        }
        return new ChiselingContext(this.world, this.chiselMode, this.modeOfOperandus, this.complete, IMutatorFactory.getInstance().covering(this.world, this.mutator.getInWorldStartPoint(), this.mutator.getInWorldEndPoint()), this.playerEntity);
    }

    private <T> Optional<T> snapshotMetadata(IMetadataKey<T> key) {
        Optional<Object> value = this.getMetadata(key);
        return value.map(key::snapshot);
    }

    @Override
    public boolean tryDamageItem(int damage) {
        if (!this.supportsDamaging || this.simulation) {
            return true;
        }
        AtomicBoolean broken = new AtomicBoolean(false);
        this.causingItemStack.func_222118_a(damage, (LivingEntity)this.playerEntity, playerEntity -> {
            broken.set(true);
            Hand hand = Hand.MAIN_HAND;
            if (playerEntity.func_184592_cb() == this.causingItemStack) {
                hand = Hand.OFF_HAND;
            }
            playerEntity.func_213334_d(hand);
        });
        return !broken.get();
    }

    @Override
    public void setStateFilter(@NotNull Function<IAreaAccessor, Predicate<IStateEntryInfo>> filter) {
        this.filterBuilder = filter;
    }

    @Override
    public void clearStateFilter() {
        this.filterBuilder = null;
    }

    @Override
    public Optional<Function<IAreaAccessor, Predicate<IStateEntryInfo>>> getStateFilter() {
        return Optional.ofNullable(this.filterBuilder);
    }

    @Override
    public <T> Optional<T> getMetadata(IMetadataKey<T> key) {
        Object value = this.metadataKeyMap.get(key);
        if (value == null) {
            return Optional.empty();
        }
        try {
            Object castValue = value;
            return Optional.ofNullable(castValue);
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Override
    public void removeMetadata(IMetadataKey<?> key) {
        this.metadataKeyMap.remove(key);
    }

    @Override
    public <T> void setMetadata(IMetadataKey<T> key, T value) {
        this.metadataKeyMap.put(key, value);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vector3d inAreaTarget) {
        if (this.getMutator().isPresent() && this.getMutator().map(m -> m.isInside(inAreaTarget)).orElse(false).booleanValue()) {
            return this.getMutator().flatMap(m -> m.getInAreaTarget(inAreaTarget));
        }
        BlockPos position = new BlockPos(inAreaTarget);
        Vector3d inBlockOffset = inAreaTarget.func_178786_a((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p());
        return IMutatorFactory.getInstance().in(this.getWorld(), position).getInAreaTarget(inBlockOffset);
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        return this.getInAreaTarget(Vector3d.func_237491_b_((Vector3i)inAreaBlockPosOffset).func_178787_e(inBlockTarget));
    }
}

