/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.model.baked.base.BaseSmartModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.chiseled.VoxelType;
import mod.chiselsandbits.client.model.baked.simple.CombinedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.registrars.ModModelProperties;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;

public class DataAwareChiseledBlockBakedModel
extends BaseSmartModel {
    public boolean func_230044_c_() {
        return true;
    }

    @Override
    public IBakedModel handleBlockState(BlockState state, Random random, IModelData modelData) {
        if (!modelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY) && !modelData.hasProperty(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY)) {
            return NullBakedModel.instance;
        }
        if (!modelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY) || MinecraftForgeClient.getRenderLayer() == null) {
            return (IBakedModel)modelData.getData(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY);
        }
        return ((Map)modelData.getData(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY)).getOrDefault(MinecraftForgeClient.getRenderLayer(), NullBakedModel.instance);
    }

    @Override
    public IBakedModel resolve(IBakedModel originalModel, ItemStack stack, World world, LivingEntity entity) {
        IBakedModel[] typedModels;
        Item item = stack.func_77973_b();
        if (!(item instanceof IMultiStateItem)) {
            return NullBakedModel.instance;
        }
        IMultiStateItem multiStateItem = (IMultiStateItem)item;
        IMultiStateItemStack multiStateItemStack = multiStateItem.createItemStack(stack);
        try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Building individual render type models");){
            typedModels = (IBakedModel[])Arrays.stream(VoxelType.values()).map(ChiselRenderType::getRenderTypes).filter(types -> !types.isEmpty()).map(types -> {
                IBakedModel[] models = (IBakedModel[])types.stream().map(type -> ChiseledBlockBakedModelManager.getInstance().get(multiStateItemStack, (ChiselRenderType)((Object)((Object)type)))).filter(Optional::isPresent).map(Optional::get).filter(model -> !model.isEmpty()).toArray(IBakedModel[]::new);
                if (models.length == 0) {
                    return ChiseledBlockBakedModel.EMPTY;
                }
                return new CombinedModel(models);
            }).toArray(IBakedModel[]::new);
        }
        if (typedModels.length == 0) {
            return ChiseledBlockBakedModel.EMPTY;
        }
        ignored1 = ProfilingManager.getInstance().withSection("Combining model data");
        try {
            CombinedModel combinedModel = new CombinedModel(typedModels);
            return combinedModel;
        }
        finally {
            if (ignored1 != null) {
                ignored1.close();
            }
        }
    }
}

