/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.BitSet;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidRenderingManager {
    private static final FluidRenderingManager INSTANCE = new FluidRenderingManager();
    private boolean renderTypesSetup = false;
    private final BitSet renderTypes = new BitSet(RenderType.func_228661_n_().size());

    public static FluidRenderingManager getInstance() {
        return INSTANCE;
    }

    private FluidRenderingManager() {
    }

    private void setupRenderTypes() {
        if (this.renderTypesSetup) {
            return;
        }
        this.renderTypes.clear();
        List blockRenderTypes = RenderType.func_228661_n_();
        block0: for (int i = 0; i < blockRenderTypes.size(); ++i) {
            RenderType renderType = (RenderType)blockRenderTypes.get(i);
            for (Fluid fluid : ForgeRegistries.FLUIDS) {
                if (!RenderTypeLookup.canRenderInLayer((FluidState)fluid.func_207188_f(), (RenderType)renderType)) continue;
                this.renderTypes.set(i);
                continue block0;
            }
        }
        this.renderTypesSetup = true;
    }

    public boolean isFluidRenderType(RenderType renderType) {
        this.setupRenderTypes();
        return this.renderTypes.get(RenderType.func_228661_n_().indexOf(renderType));
    }
}

