/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.screens.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.client.screen.widget.AbstractChiselsAndBitsWidget;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.item.withmode.IRenderableMode;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.jetbrains.annotations.NotNull;

public class RadialSelectionWidget
extends AbstractChiselsAndBitsWidget {
    private static final float DRAWS = 720.0f;
    private final Supplier<IRenderableMode> currentlySelectedModeSupplier;
    private final Consumer<IRenderableMode> currentlyHoveredModeCallback;
    private final Consumer<IRenderableMode> currentlyClickedModeCallback;
    private final List<? extends IRenderableMode> modes;
    private final float sectionArcAngle;
    private final float sectionStartAngle;
    private final float innerSelectionRadius;
    private final float outerSelectionRadius;
    private final boolean keepSelectionWhenBeyondOuterSelectionRadius;
    private final float innerRadius;
    private final float outerRadius;
    private final float iconSize;
    private final float iconScaleFactor;
    private final int iconTextSpacer;
    private final FontRenderer fontRenderer;
    private final float centerX;
    private final float centerY;

    public RadialSelectionWidget(Screen screen, int width, int height, ITextComponent message, Supplier<IRenderableMode> currentlySelectedModeSupplier, Consumer<IRenderableMode> currentlyHoveredModeCallback, Consumer<IRenderableMode> currentlyClickedModeCallback, List<IRenderableMode> modes, float sectionArcAngle, float sectionStartAngle, boolean hideInactiveIcons, float innerSelectionRadius, float outerSelectionRadius, boolean keepSelectionWhenBeyondOuterSelectionRadius, float innerRadius, float outerRadius, float iconSize, float iconScaleFactor, int iconTextSpacer, FontRenderer fontRenderer) {
        this((int)((float)screen.field_230708_k_ / 2.0f - (float)width / 2.0f), (int)((float)screen.field_230709_l_ / 2.0f - (float)height / 2.0f), width, height, message, currentlySelectedModeSupplier, currentlyHoveredModeCallback, currentlyClickedModeCallback, modes, sectionArcAngle, sectionStartAngle, hideInactiveIcons, innerSelectionRadius, outerSelectionRadius, keepSelectionWhenBeyondOuterSelectionRadius, innerRadius, outerRadius, iconSize, iconScaleFactor, iconTextSpacer, fontRenderer);
    }

    public RadialSelectionWidget(int x, int y, int width, int height, ITextComponent message, Supplier<IRenderableMode> currentlySelectedModeSupplier, Consumer<IRenderableMode> currentlyHoveredModeCallback, Consumer<IRenderableMode> currentlyClickedModeCallback, List<? extends IRenderableMode> modes, float sectionArcAngle, float sectionStartAngle, boolean hideInactiveIcons, float innerSelectionRadius, float outerSelectionRadius, boolean keepSelectionWhenBeyondOuterSelectionRadius, float innerRadius, float outerRadius, float iconSize, float iconScaleFactor, int iconTextSpacer, FontRenderer fontRenderer) {
        super(x, y, width, height, message);
        this.currentlySelectedModeSupplier = currentlySelectedModeSupplier;
        this.currentlyHoveredModeCallback = currentlyHoveredModeCallback;
        this.currentlyClickedModeCallback = currentlyClickedModeCallback;
        this.keepSelectionWhenBeyondOuterSelectionRadius = keepSelectionWhenBeyondOuterSelectionRadius;
        this.modes = modes.stream().filter(mode -> !hideInactiveIcons || mode.isActive()).collect(Collectors.toList());
        this.sectionArcAngle = sectionArcAngle;
        this.sectionStartAngle = sectionStartAngle;
        this.innerSelectionRadius = innerSelectionRadius;
        this.outerSelectionRadius = outerSelectionRadius;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.iconSize = iconSize;
        this.iconScaleFactor = iconScaleFactor;
        this.iconTextSpacer = iconTextSpacer;
        this.fontRenderer = fontRenderer;
        this.centerX = (float)x + (float)width / 2.0f;
        this.centerY = (float)y + (float)height / 2.0f;
    }

    public <G extends IToolModeGroup> RadialSelectionWidget(AbstractChiselsAndBitsWidget widget, int width, int height, ITextComponent message, Supplier<IRenderableMode> currentlySelectedModeSupplier, Consumer<IRenderableMode> currentlyHoveredModeCallback, Consumer<IRenderableMode> currentlyClickedModeCallback, List<? extends IRenderableMode> modes, float sectionArcAngle, float sectionStartAngle, boolean hideInactiveIcons, float innerSelectionRadius, float outerSelectionRadius, boolean keepSelectionWhenBeyondOuterSelectionRadius, float innerRadius, float outerRadius, float iconSize, float iconScaleFactor, int iconTextSpacer, FontRenderer fontRenderer) {
        this((int)((float)widget.field_230690_l_ + (float)widget.func_230998_h_() / 2.0f - (float)width / 2.0f), (int)((float)widget.field_230691_m_ + (float)widget.func_238483_d_() / 2.0f - (float)height / 2.0f), width, height, message, currentlySelectedModeSupplier, currentlyHoveredModeCallback, currentlyClickedModeCallback, modes, sectionArcAngle, sectionStartAngle, hideInactiveIcons, innerSelectionRadius, outerSelectionRadius, keepSelectionWhenBeyondOuterSelectionRadius, innerRadius, outerRadius, iconSize, iconScaleFactor, iconTextSpacer, fontRenderer);
    }

    public void func_230431_b_(@NotNull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int hoveredItemIndex;
        IRenderableMode current = this.currentlySelectedModeSupplier.get();
        int selectableItemCount = this.modes.size();
        if (selectableItemCount == 0) {
            return;
        }
        float centerX = (float)this.field_230690_l_ + (float)this.field_230688_j_ / 2.0f;
        float centerY = (float)this.field_230691_m_ + (float)this.field_230689_k_ / 2.0f;
        matrixStack.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.defaultAlphaFunc();
        matrixStack.func_227861_a_((double)centerX, (double)centerY, 0.0);
        RenderSystem.disableTexture();
        float itemArcAngle = this.sectionArcAngle / (float)selectableItemCount;
        float mouseAngle = RadialSelectionWidget.calculateMouseAngle(mouseX, mouseY, centerX, centerY);
        float mouseRadius = RadialSelectionWidget.calculateMouseRadius(mouseX, mouseY, centerX, centerY);
        float inSectionMouseAngle = mouseAngle - this.sectionStartAngle;
        boolean mouseIsInSectionArc = inSectionMouseAngle >= 0.0f && inSectionMouseAngle <= this.sectionArcAngle;
        boolean isMouseInSection = mouseIsInSectionArc && mouseRadius >= this.innerSelectionRadius && mouseRadius <= this.outerSelectionRadius;
        int n = hoveredItemIndex = !isMouseInSection ? -1 : (int)(inSectionMouseAngle / itemArcAngle);
        if (!isMouseInSection && current != null && this.modes.contains(current) && this.keepSelectionWhenBeyondOuterSelectionRadius && mouseIsInSectionArc && mouseRadius >= this.innerSelectionRadius) {
            isMouseInSection = true;
            hoveredItemIndex = this.modes.indexOf(current);
        }
        RenderSystem.enableBlend();
        int renderableHoveredItemIndex = hoveredItemIndex;
        this.modes.forEach(mode -> {
            int modeIndex = this.modes.indexOf(mode);
            boolean isSelected = current != null && mode == current;
            boolean isHovered = renderableHoveredItemIndex == modeIndex;
            float itemTargetAngle = ((float)modeIndex + 0.5f) * itemArcAngle + this.sectionStartAngle;
            if (mode.isActive()) {
                RadialSelectionWidget.drawSelectableSection(matrixStack, this.sectionArcAngle, this.innerRadius, this.outerRadius, selectableItemCount, itemTargetAngle, isSelected, isHovered);
            } else {
                RadialSelectionWidget.drawDeactivatedSection(matrixStack, this.sectionArcAngle, this.innerRadius, this.outerRadius, selectableItemCount, itemTargetAngle);
            }
        });
        RenderSystem.disableBlend();
        if (isMouseInSection && hoveredItemIndex >= 0 && hoveredItemIndex < this.modes.size() && this.modes.get(hoveredItemIndex).isActive()) {
            if (((Boolean)Configuration.getInstance().getClient().enableMouseIndicatorInRadialMenu.get()).booleanValue()) {
                float startOfMouseArcAngle = mouseAngle - itemArcAngle / 2.0f;
                float mouseArcAngle = itemArcAngle;
                if (this.sectionArcAngle != 360.0f) {
                    if (startOfMouseArcAngle < this.sectionStartAngle) {
                        mouseArcAngle -= this.sectionStartAngle - startOfMouseArcAngle;
                        startOfMouseArcAngle = this.sectionStartAngle;
                    }
                    if (startOfMouseArcAngle + mouseArcAngle > this.sectionStartAngle + this.sectionArcAngle) {
                        mouseArcAngle = this.sectionStartAngle + this.sectionArcAngle - startOfMouseArcAngle;
                    }
                }
                RenderSystem.color4f((float)0.8f, (float)0.8f, (float)0.8f, (float)0.3f);
                RadialSelectionWidget.drawTorus(matrixStack, startOfMouseArcAngle - 90.0f, mouseArcAngle, this.innerRadius, this.outerRadius);
            }
            if (hoveredItemIndex >= 0 && this.modes.get(hoveredItemIndex) != current) {
                this.currentlyHoveredModeCallback.accept(this.modes.get(hoveredItemIndex));
            }
        } else if (current != null) {
            this.currentlyHoveredModeCallback.accept(null);
        }
        RenderSystem.enableTexture();
        this.modes.forEach(mode -> {
            if (mode.isActive()) {
                int modeIndex = this.modes.indexOf(mode);
                float itemTargetAngle = ((float)modeIndex + 0.5f) * itemArcAngle + this.sectionStartAngle;
                this.renderModeIcon(matrixStack, this.innerRadius, this.outerRadius, itemTargetAngle, this.iconScaleFactor, this.iconTextSpacer, (IRenderableMode)mode, this.fontRenderer);
            }
        });
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227865_b_();
        RenderSystem.enableTexture();
    }

    private static float calculateMouseAngle(float mouseX, float mouseY, float centerX, float centerY) {
        float mouseAngle;
        float xDiff = mouseX - centerX;
        float yDiff = mouseY - centerY;
        for (mouseAngle = (float)Math.toDegrees(Math.atan2(yDiff, xDiff)) - 270.0f; mouseAngle < 0.0f; mouseAngle += 360.0f) {
        }
        return mouseAngle;
    }

    private static float calculateMouseRadius(float mouseX, float mouseY, float centerX, float centerY) {
        float xDiff = mouseX - centerX;
        float yDiff = mouseY - centerY;
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    private static void drawSelectableSection(@NotNull MatrixStack stack, float sectionArcAngle, float innerRadius, float outerRadius, int itemCountInSection, float itemTargetAngle, boolean isSelected, boolean isHovered) {
        float itemArcAngle = sectionArcAngle / (float)itemCountInSection;
        float itemRenderAngle = itemTargetAngle - 90.0f;
        float sectionStartAngle = itemRenderAngle - itemArcAngle / 2.0f;
        RenderSystem.color4f((float)0.3f, (float)0.3f, (float)0.3f, (float)0.3f);
        RadialSelectionWidget.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        if (isSelected) {
            RenderSystem.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)0.7f);
            RadialSelectionWidget.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        }
        if (isHovered) {
            RenderSystem.color4f((float)0.7f, (float)0.7f, (float)0.7f, (float)0.7f);
            RadialSelectionWidget.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        }
    }

    private static void drawDeactivatedSection(@NotNull MatrixStack stack, float sectionArcAngle, float innerRadius, float outerRadius, int itemCountInSection, float itemTargetAngle) {
        float itemArcAngle = sectionArcAngle / (float)itemCountInSection;
        float itemRenderAngle = itemTargetAngle - 90.0f;
        float sectionStartAngle = itemRenderAngle - itemArcAngle / 2.0f;
        RenderSystem.color4f((float)0.1f, (float)0.1f, (float)0.1f, (float)0.1f);
        RadialSelectionWidget.drawTorus(stack, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
    }

    private static void drawTorus(MatrixStack matrix, float startAngle, float sizeAngle, float inner, float outer) {
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        vertexBuffer.func_181668_a(8, DefaultVertexFormats.field_181705_e);
        float draws = 720.0f * (sizeAngle / 360.0f);
        int i = 0;
        while ((float)i <= draws) {
            float angle = (float)Math.toRadians(startAngle + (float)i / 720.0f * 360.0f);
            vertexBuffer.func_227888_a_(matrix4f, (float)((double)outer * Math.cos(angle)), (float)((double)outer * Math.sin(angle)), 0.0f).func_181675_d();
            vertexBuffer.func_227888_a_(matrix4f, (float)((double)inner * Math.cos(angle)), (float)((double)inner * Math.sin(angle)), 0.0f).func_181675_d();
            ++i;
        }
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
    }

    private void renderModeIcon(@NotNull MatrixStack stack, float innerRadius, float outerRadius, float itemTargetAngle, float iconScaleFactor, int iconTextSpacer, @NotNull IRenderableMode mode, FontRenderer fontRenderer) {
        int n;
        float workingAngle;
        for (workingAngle = itemTargetAngle - 90.0f; workingAngle < 0.0f; workingAngle += 360.0f) {
        }
        float itemCenterX = (float)Math.cos(Math.toRadians(workingAngle)) * (innerRadius + outerRadius) / 2.0f;
        float itemCenterY = (float)Math.sin(Math.toRadians(workingAngle)) * (innerRadius + outerRadius) / 2.0f;
        ITextComponent name = mode.getMultiLineDisplayName();
        List lines = fontRenderer.func_238425_b_((ITextProperties)name, 75);
        if (mode.shouldRenderDisplayNameInMenu()) {
            float f = this.iconSize * iconScaleFactor + (float)iconTextSpacer;
            Objects.requireNonNull(fontRenderer);
            n = (int)(f + (float)(9 * lines.size()));
        } else {
            n = (int)(this.iconSize * iconScaleFactor);
        }
        int itemHeight = n;
        float iconStartX = itemCenterX - this.iconSize * iconScaleFactor / 2.0f;
        float iconStartY = itemCenterY - (float)itemHeight / 2.0f;
        stack.func_227860_a_();
        RenderSystem.color4f((float)((float)mode.getColorVector().func_82615_a()), (float)((float)mode.getColorVector().func_82617_b()), (float)((float)mode.getColorVector().func_82616_c()), (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(mode.getIcon());
        RadialSelectionWidget.func_238466_a_((MatrixStack)stack, (int)((int)iconStartX), (int)((int)iconStartY), (int)((int)(this.iconSize * iconScaleFactor)), (int)((int)(this.iconSize * iconScaleFactor)), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        stack.func_227860_a_();
        if (mode.shouldRenderDisplayNameInMenu()) {
            stack.func_227861_a_((double)itemCenterX, (double)itemCenterY, 0.0);
            stack.func_227862_a_(0.6f * iconScaleFactor, 0.6f * iconScaleFactor, 0.6f * iconScaleFactor);
            int offset = 0;
            for (IReorderingProcessor line : lines) {
                fontRenderer.func_238422_b_(stack, line, (float)fontRenderer.func_243245_a(line) / -2.0f, (float)(iconTextSpacer + offset), -855638017);
                Objects.requireNonNull(fontRenderer);
                offset += 9;
            }
        }
        stack.func_227865_b_();
        stack.func_227865_b_();
    }

    protected boolean func_230987_a_(int usedButton) {
        return usedButton == 0;
    }

    protected boolean func_230992_c_(double mouseX, double mouseY) {
        int hoveredItemIndex;
        if (!this.field_230693_o_ || !this.field_230694_p_) {
            return false;
        }
        int selectableItemCount = this.modes.size();
        if (selectableItemCount == 0) {
            return false;
        }
        float itemArcAngle = this.sectionArcAngle / (float)selectableItemCount;
        float mouseAngle = RadialSelectionWidget.calculateMouseAngle((float)mouseX, (float)mouseY, this.centerX, this.centerY);
        float mouseRadius = RadialSelectionWidget.calculateMouseRadius((float)mouseX, (float)mouseY, this.centerX, this.centerY);
        float inSectionMouseAngle = mouseAngle - this.sectionStartAngle;
        boolean mouseIsInSectionArc = inSectionMouseAngle >= 0.0f && inSectionMouseAngle <= this.sectionArcAngle;
        boolean isMouseInSection = mouseIsInSectionArc && mouseRadius >= this.innerSelectionRadius && mouseRadius <= this.outerSelectionRadius;
        int n = hoveredItemIndex = !isMouseInSection ? -1 : (int)(inSectionMouseAngle / itemArcAngle);
        if (hoveredItemIndex == -1) {
            return false;
        }
        this.currentlyClickedModeCallback.accept(this.modes.get(hoveredItemIndex));
        return true;
    }
}

