/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.click.IRightClickControllingItem;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.api.modification.operation.IModificationOperation;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.util.RayTracingUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.registries.ForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WrenchItem
extends Item
implements IWithModeItem<IModificationOperation>,
IRightClickControllingItem {
    private static final Logger LOGGER = LogManager.getLogger();

    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public IModificationOperation getMode(ItemStack stack) {
        CompoundNBT stackNbt = stack.func_196082_o();
        if (stackNbt.func_74764_b("modificationMode")) {
            String modeName = stackNbt.func_74779_i("modificationMode");
            try {
                IModificationOperation registryMode = (IModificationOperation)IModificationOperation.getRegistry().getValue(new ResourceLocation(modeName));
                if (registryMode == null) {
                    return IModificationOperation.getDefaultMode();
                }
                return registryMode;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error(String.format("An ItemStack got loaded with a name that is not a valid modification mode: %s", modeName));
                this.setMode(stack, IModificationOperation.getDefaultMode());
            }
        }
        return IModificationOperation.getDefaultMode();
    }

    @Override
    public void setMode(ItemStack stack, IModificationOperation mode) {
        if (mode == null) {
            return;
        }
        stack.func_196082_o().func_74778_a("modificationMode", Objects.requireNonNull(mode.getRegistryName()).toString());
    }

    @Override
    @NotNull
    public Collection<IModificationOperation> getPossibleModes() {
        return IModificationOperation.getRegistry().getValues().stream().sorted(Comparator.comparing(arg_0 -> ((ForgeRegistry)((ForgeRegistry)IModificationOperation.getRegistry())).getID(arg_0))).collect(Collectors.toList());
    }

    @Override
    public boolean canUse(PlayerEntity playerEntity) {
        RayTraceResult result = RayTracingUtils.rayTracePlayer(playerEntity);
        if (!(result instanceof BlockRayTraceResult) || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockRayTraceResult blockHitResult = (BlockRayTraceResult)result;
        TileEntity blockEntity = playerEntity.field_70170_p.func_175625_s(blockHitResult.func_216350_a());
        return blockEntity instanceof IMultiStateBlockEntity;
    }

    @Override
    public ClickProcessingState handleRightClickProcessing(PlayerEntity playerEntity, Hand hand, BlockPos position, Direction face, ClickProcessingState currentState) {
        RayTraceResult result = RayTracingUtils.rayTracePlayer(playerEntity);
        if (!(result instanceof BlockRayTraceResult) || result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ClickProcessingState.DENIED;
        }
        BlockRayTraceResult blockHitResult = (BlockRayTraceResult)result;
        TileEntity blockEntity = playerEntity.field_70170_p.func_175625_s(blockHitResult.func_216350_a());
        if (!(blockEntity instanceof IMultiStateBlockEntity)) {
            return ClickProcessingState.DENIED;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
        try (IBatchMutation ignored = multiStateBlockEntity.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
            this.getMode(playerEntity.func_184586_b(hand)).apply(multiStateBlockEntity);
        }
        return ClickProcessingState.ALLOW;
    }
}

