/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.mixin;

import fionathemortal.betterbiomeblend.BiomeCache;
import fionathemortal.betterbiomeblend.BlendCache;
import fionathemortal.betterbiomeblend.ColorCache;
import fionathemortal.betterbiomeblend.ColorCaching;
import fionathemortal.betterbiomeblend.ColorChunk;
import fionathemortal.betterbiomeblend.CustomColorResolverCompatibility;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.storage.ISpawnWorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientWorld.class})
public abstract class MixinClientWorld
extends World {
    @Shadow
    private final Object2ObjectArrayMap<ColorResolver, net.minecraft.client.renderer.color.ColorCache> field_228315_B_ = new Object2ObjectArrayMap();
    @Unique
    private final BlendCache betterBiomeBlend$blendColorCache = new BlendCache(2048);
    @Unique
    private final ColorCache betterBiomeBlend$chunkColorCache = new ColorCache(512);
    @Unique
    private final BiomeCache betterBiomeBlend$chunkBiomeCache = new BiomeCache(32);
    @Unique
    private final ThreadLocal<ColorChunk> betterBiomeBlend$threadLocalWaterChunk = ThreadLocal.withInitial(() -> {
        ColorChunk chunk = new ColorChunk();
        chunk.acquire();
        return chunk;
    });
    @Unique
    private final ThreadLocal<ColorChunk> betterBiomeBlend$threadLocalGrassChunk = ThreadLocal.withInitial(() -> {
        ColorChunk chunk = new ColorChunk();
        chunk.acquire();
        return chunk;
    });
    @Unique
    private final ThreadLocal<ColorChunk> betterBiomeBlend$threadLocalFoliageChunk = ThreadLocal.withInitial(() -> {
        ColorChunk chunk = new ColorChunk();
        chunk.acquire();
        return chunk;
    });
    @Unique
    private final ThreadLocal<ColorChunk> betterBiomeBlend$threadLocalGenericChunk = ThreadLocal.withInitial(() -> {
        ColorChunk chunk = new ColorChunk();
        chunk.acquire();
        return chunk;
    });

    protected MixinClientWorld(ISpawnWorldInfo worldInfo, RegistryKey<World> dimension, DimensionType dimensionType, Supplier<IProfiler> profiler, boolean isRemote, boolean isDebug, long seed) {
        super(worldInfo, dimension, dimensionType, profiler, isRemote, isDebug, seed);
    }

    @Inject(method={"clearColorCaches"}, at={@At(value="HEAD")})
    public void onClearColorCaches(CallbackInfo ci) {
        this.betterBiomeBlend$blendColorCache.invalidateAll();
        this.betterBiomeBlend$chunkColorCache.invalidateAll();
        this.betterBiomeBlend$chunkBiomeCache.invalidateAll();
    }

    @Inject(method={"onChunkLoaded"}, at={@At(value="HEAD")})
    public void onOnChunkLoaded(int chunkX, int chunkZ, CallbackInfo ci) {
        this.betterBiomeBlend$blendColorCache.invalidateChunk(chunkX, chunkZ);
        this.betterBiomeBlend$chunkColorCache.invalidateSmallNeighborhood(chunkX, chunkZ);
        this.betterBiomeBlend$chunkBiomeCache.invalidateSmallNeighborhood(chunkX, chunkZ);
    }

    @Overwrite
    public int func_225525_a_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        ThreadLocal<ColorChunk> threadLocalChunk;
        int colorType;
        if (colorResolverIn == BiomeColors.field_180291_a) {
            colorType = 0;
            threadLocalChunk = this.betterBiomeBlend$threadLocalGrassChunk;
        } else if (colorResolverIn == BiomeColors.field_180290_c) {
            colorType = 1;
            threadLocalChunk = this.betterBiomeBlend$threadLocalWaterChunk;
        } else if (colorResolverIn == BiomeColors.field_180289_b) {
            colorType = 2;
            threadLocalChunk = this.betterBiomeBlend$threadLocalFoliageChunk;
        } else {
            colorType = CustomColorResolverCompatibility.getColorType(colorResolverIn);
            threadLocalChunk = this.betterBiomeBlend$threadLocalGenericChunk;
        }
        int x = blockPosIn.func_177958_n();
        int z = blockPosIn.func_177952_p();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        ColorChunk chunk = ColorCaching.getThreadLocalChunk(threadLocalChunk, chunkX, chunkZ, colorType);
        if (chunk == null) {
            chunk = ColorCaching.getBlendedColorChunk(this, colorResolverIn, colorType, chunkX, chunkZ, this.betterBiomeBlend$blendColorCache, this.betterBiomeBlend$chunkColorCache, this.betterBiomeBlend$chunkBiomeCache);
            ColorCaching.setThreadLocalChunk(threadLocalChunk, chunk, this.betterBiomeBlend$blendColorCache);
        }
        int result = chunk.getColor(x, z);
        return result;
    }
}

