/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.items;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.untitledduckmod.ModEntityTypes;
import net.untitledduckmod.ModItems;
import net.untitledduckmod.ModSoundEvents;
import net.untitledduckmod.duck.DuckEntity;

public class DuckSackItem
extends Item {
    public DuckSackItem(Item.Properties settings) {
        super(settings);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        Direction blockSide = context.func_196000_l();
        Hand hand = context.func_221531_n();
        if (!world.field_72995_K) {
            this.placeCreature((ServerWorld)world, pos.func_177972_a(blockSide), context.func_195996_i().func_77978_p());
            if (player != null) {
                player.func_184609_a(hand);
                if (!player.func_184812_l_()) {
                    player.func_184611_a(hand, new ItemStack((IItemProvider)ModItems.getEmptyDuckSack()));
                }
            }
        }
        world.func_184133_a(player, pos, ModSoundEvents.getDuckSackUse(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    private void placeCreature(ServerWorld world, BlockPos pos, CompoundNBT entityData) {
        UUID uuid;
        if (entityData != null && entityData.func_74764_b("EntityTag") && entityData.func_74775_l("EntityTag").func_186855_b("UUID") && world.func_217461_a(uuid = entityData.func_74775_l("EntityTag").func_186857_a("UUID")) != null) {
            entityData.func_74775_l("EntityTag").func_82580_o("UUID");
        }
        DuckEntity newDuck = (DuckEntity)ModEntityTypes.getDuck().func_220349_b(world, entityData, null, null, pos, SpawnReason.BUCKET, true, false);
        assert (newDuck != null) : "newDuck is null? This should not happen :(";
        newDuck.setFromSack(true);
        newDuck.func_226288_n_(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        newDuck.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        world.func_217376_c((Entity)newDuck);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT duckData;
        if (stack.func_77942_o() && (duckData = stack.func_77978_p()) != null && duckData.func_74764_b("EntityTag") && duckData.func_74775_l("EntityTag").func_74764_b("CustomName")) {
            IFormattableTextComponent duckName = ITextComponent.Serializer.func_240643_a_((String)duckData.func_74775_l("EntityTag").func_74779_i("CustomName"));
            return new TranslationTextComponent("item.untitledduckmod.duck_sack.named", new Object[]{duckName});
        }
        return super.func_200295_i(stack);
    }
}

