/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.blocks;

import com.minecraftabnormals.upgrade_aquatic.client.particle.UAParticles;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.TorchBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JellyTorchBlock
extends TorchBlock
implements IBucketPickupHandler,
ILiquidContainer {
    private final JellyTorchType torchType;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public JellyTorchBlock(AbstractBlock.Properties props, JellyTorchType torchType) {
        super(props, null);
        this.torchType = torchType;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        double xOffset = rand.nextBoolean() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double yOffset = rand.nextBoolean() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double zOffset = rand.nextBoolean() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double d0 = (double)pos.func_177958_n() + 0.5 + xOffset;
        double d1 = (double)pos.func_177956_o() + 0.5 + yOffset;
        double d2 = (double)pos.func_177952_p() + 0.5 + zOffset;
        world.func_195594_a((IParticleData)JellyTorchType.getTorchParticleType(this.torchType), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, stateIn, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false && fluidIn == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public static enum JellyTorchType {
        PINK(TextFormatting.LIGHT_PURPLE, () -> (Block)UABlocks.PINK_JELLY_TORCH.get()),
        PURPLE(TextFormatting.DARK_PURPLE, () -> (Block)UABlocks.PURPLE_JELLY_TORCH.get()),
        BLUE(TextFormatting.BLUE, () -> (Block)UABlocks.BLUE_JELLY_TORCH.get()),
        GREEN(TextFormatting.GREEN, () -> (Block)UABlocks.GREEN_JELLY_TORCH.get()),
        YELLOW(TextFormatting.YELLOW, () -> (Block)UABlocks.YELLOW_JELLY_TORCH.get()),
        ORANGE(TextFormatting.GOLD, () -> (Block)UABlocks.ORANGE_JELLY_TORCH.get()),
        RED(TextFormatting.RED, () -> (Block)UABlocks.RED_JELLY_TORCH.get()),
        WHITE(TextFormatting.WHITE, () -> (Block)UABlocks.WHITE_JELLY_TORCH.get());

        public final TextFormatting color;
        public final Supplier<Block> torch;

        private JellyTorchType(TextFormatting color, Supplier<Block> torch) {
            this.color = color;
            this.torch = torch;
        }

        public static BasicParticleType getTorchParticleType(JellyTorchType type) {
            switch (type) {
                default: {
                    return (BasicParticleType)UAParticles.PINK_JELLY_FLAME.get();
                }
                case PURPLE: {
                    return (BasicParticleType)UAParticles.PURPLE_JELLY_FLAME.get();
                }
                case BLUE: {
                    return (BasicParticleType)UAParticles.BLUE_JELLY_FLAME.get();
                }
                case GREEN: {
                    return (BasicParticleType)UAParticles.GREEN_JELLY_FLAME.get();
                }
                case YELLOW: {
                    return (BasicParticleType)UAParticles.YELLOW_JELLY_FLAME.get();
                }
                case ORANGE: {
                    return (BasicParticleType)UAParticles.ORANGE_JELLY_FLAME.get();
                }
                case RED: {
                    return (BasicParticleType)UAParticles.RED_JELLY_FLAME.get();
                }
                case WHITE: 
            }
            return (BasicParticleType)UAParticles.WHITE_JELLY_FLAME.get();
        }

        public static BasicParticleType getBlobParticleType(JellyTorchType type) {
            switch (type) {
                default: {
                    return (BasicParticleType)UAParticles.PINK_JELLY_BLOB.get();
                }
                case PURPLE: {
                    return (BasicParticleType)UAParticles.PURPLE_JELLY_BLOB.get();
                }
                case BLUE: {
                    return (BasicParticleType)UAParticles.BLUE_JELLY_BLOB.get();
                }
                case GREEN: {
                    return (BasicParticleType)UAParticles.GREEN_JELLY_BLOB.get();
                }
                case YELLOW: {
                    return (BasicParticleType)UAParticles.YELLOW_JELLY_BLOB.get();
                }
                case ORANGE: {
                    return (BasicParticleType)UAParticles.ORANGE_JELLY_BLOB.get();
                }
                case RED: {
                    return (BasicParticleType)UAParticles.RED_JELLY_BLOB.get();
                }
                case WHITE: 
            }
            return (BasicParticleType)UAParticles.WHITE_JELLY_BLOB.get();
        }
    }
}

