/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.items;

import com.minecraftabnormals.abnormals_core.core.util.item.filling.TargetedItemGroupFiller;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.core.other.JellyfishRegistry;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UASounds;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class JellyfishBucketItem
extends BucketItem {
    private static final TargetedItemGroupFiller FILLER = new TargetedItemGroupFiller(() -> Items.field_204272_aO);

    public JellyfishBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public void func_203792_a(World worldIn, ItemStack stack, BlockPos pos) {
        if (worldIn instanceof ServerWorld) {
            this.placeEntity((ServerWorld)worldIn, stack, pos);
        }
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, (SoundEvent)UASounds.ITEM_BUCKET_EMPTY_JELLYFISH.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeEntity(ServerWorld world, ItemStack stack, BlockPos pos) {
        AbstractJellyfishEntity jellyfish = this.getEntityInStack(stack, (World)world, pos);
        if (jellyfish != null) {
            jellyfish.setFromBucket(true);
        }
    }

    @Nullable
    public AbstractJellyfishEntity getEntityInStack(ItemStack stack, World world, @Nullable BlockPos pos) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_74764_b("JellyfishTag")) {
            AbstractJellyfishEntity jellyfish;
            CompoundNBT jellyfishTag = compoundnbt.func_74775_l("JellyfishTag");
            String entityId = jellyfishTag.func_74779_i("EntityId");
            EntityType jellyfishType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("upgrade_aquatic:" + entityId));
            Entity entity = pos != null ? jellyfishType.func_220331_a((ServerWorld)world, stack, null, pos, SpawnReason.BUCKET, true, false) : jellyfishType.func_200721_a(world);
            AbstractJellyfishEntity abstractJellyfishEntity = jellyfish = entity instanceof AbstractJellyfishEntity ? (AbstractJellyfishEntity)entity : null;
            if (jellyfish == null) {
                return null;
            }
            jellyfish.getBucketProcessor().read(jellyfishTag);
            return jellyfish;
        }
        if (pos != null) {
            AbstractJellyfishEntity jellyfish = this.getRandomJellyfish(stack, world, pos);
            return jellyfish;
        }
        return null;
    }

    private AbstractJellyfishEntity getRandomJellyfish(ItemStack stack, World world, @Nullable BlockPos pos) {
        Random rand = new Random();
        List<JellyfishRegistry.JellyfishEntry<?>> commonJellies = JellyfishRegistry.collectJelliesMatchingRarity(Rarity.COMMON);
        return (AbstractJellyfishEntity)commonJellies.get((int)rand.nextInt((int)commonJellies.size())).jellyfish.get().func_220331_a((ServerWorld)world, stack, null, pos, SpawnReason.BUCKET, true, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        AbstractJellyfishEntity jellyfish;
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_74764_b("JellyfishTag") && (jellyfish = this.getEntityInStack(stack, worldIn, null)) != null) {
            TextFormatting[] atextformatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.upgrade_aquatic." + jellyfish.getBucketName() + "_jellyfish").func_240701_a_(atextformatting));
            tooltip.add(jellyfish.getYieldingTorchMessage());
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        FILLER.fillItem((Item)this, group, items);
    }
}

