/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.client;

import com.google.common.collect.Maps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.itsmeow.betteranimalmodels.client.forge.ReplacementsImpl;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewBee;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewCat;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewChicken;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewCow;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewDolphin;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewFox;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewHorse;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewPig;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewPolarBear;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewSheep;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewSilverfish;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewSpider;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewSquid;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewWolf;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewCatCollar;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewDolphinItem;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewFoxItem;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewHorseArmor;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewHorseMarking;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewMooshroomMushroom;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewPigSaddle;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewSheepWool;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewSpiderEyes;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewWolfCollar;
import dev.itsmeow.betteranimalmodels.imdlib.client.IMDLibClient;
import dev.itsmeow.betteranimalmodels.imdlib.client.render.ImplRenderer;
import dev.itsmeow.betteranimalmodels.imdlib.client.util.ModelReplacementHandler;
import dev.itsmeow.betteranimalmodels.imdlib.util.SafePlatform;
import java.util.Map;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class Replacements {
    public static final ModelReplacementHandler H = IMDLibClient.getReplacementHandler("betteranimalmodels");
    private static final Map<CoatColors, ResourceLocation> HORSE_VARIANTS = (Map)Util.func_200696_a((Object)Maps.newEnumMap(CoatColors.class), m -> {
        m.put(CoatColors.WHITE, Replacements.t("horse/horse_white"));
        m.put(CoatColors.CREAMY, Replacements.t("horse/horse_creamy"));
        m.put(CoatColors.CHESTNUT, Replacements.t("horse/horse_chestnut"));
        m.put(CoatColors.BROWN, Replacements.t("horse/horse_brown"));
        m.put(CoatColors.BLACK, Replacements.t("horse/horse_black"));
        m.put(CoatColors.GRAY, Replacements.t("horse/horse_gray"));
        m.put(CoatColors.DARKBROWN, Replacements.t("horse/horse_darkbrown"));
    });
    public static final ImplRenderer.RenderDef<CowEntity, EntityModel<CowEntity>> cow_f = r -> r.ageScale(0.8f, 0.4f).tSingle("cow").mSingle(new ModelNewCow());
    public static final ImplRenderer.RenderDef<PigEntity, EntityModel<PigEntity>> pig_f = r -> r.childScale(0.5f).layer(LayerNewPigSaddle::new).tSingle("pig").mSingle(new ModelNewPig());
    public static final ImplRenderer.RenderDef<ChickenEntity, EntityModel<ChickenEntity>> chicken_f = r -> r.childScale(0.45f).handleRotation((e, p) -> {
        float f = e.field_70888_h + (e.field_70886_e - e.field_70888_h) * p;
        float f1 = e.field_70884_g + (e.field_70883_f - e.field_70884_g) * p;
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }).tSingle("chicken").mSingle(new ModelNewChicken());
    public static final ImplRenderer.RenderDef<DolphinEntity, EntityModel<DolphinEntity>> dolphin_f = r -> r.layer(LayerNewDolphinItem::new).tSingle("dolphin").mSingle(new ModelNewDolphin());
    public static ImplRenderer.RenderDef<CowEntity, EntityModel<CowEntity>> cow = cow_f;
    public static ImplRenderer.RenderDef<PigEntity, EntityModel<PigEntity>> pig = pig_f;
    public static ImplRenderer.RenderDef<ChickenEntity, EntityModel<ChickenEntity>> chicken = chicken_f;
    public static ImplRenderer.RenderDef<DolphinEntity, EntityModel<DolphinEntity>> dolphin = dolphin_f;

    public static ResourceLocation t(String s) {
        return new ResourceLocation("betteranimalmodels", "textures/entity/" + s + ".png");
    }

    public static void initQuarkReplaces() {
        H.addReplace("minecraft", "cow", () -> () -> H.lambdaReplace(EntityType.field_200796_j, 1.2f, cow));
        H.addReplace("minecraft", "pig", () -> () -> H.lambdaReplace(EntityType.field_200784_X, 0.7f, pig));
        H.addReplace("minecraft", "chicken", () -> () -> H.lambdaReplace(EntityType.field_200795_i, 0.4f, chicken));
        H.addReplace("minecraft", "dolphin", () -> () -> H.lambdaReplace(EntityType.field_205137_n, 0.7f, dolphin));
    }

    public static void init() {
        if (!SafePlatform.isModLoaded("quark")) {
            Replacements.initQuarkReplaces();
        }
        H.addReplace("minecraft", "sheep", () -> () -> H.lambdaReplace(EntityType.field_200737_ac, 0.7f, r -> r.childScale(0.5f).layer(LayerNewSheepWool::new).tMapped(e -> e.func_70631_g_() ? "lamb" : "sheep").mSingle(new ModelNewSheep())));
        H.addReplace("minecraft", "wolf", () -> () -> H.lambdaReplace(EntityType.field_200724_aC, 0.7f, r -> r.preRender((e, s, p) -> {
            s.func_227862_a_(0.8f, 0.8f, 0.8f);
            if (e.func_70631_g_()) {
                s.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
        }).handleRotation((e, p) -> e.func_70920_v()).layer(LayerNewWolfCollar::new).tMapped(e -> e.func_70909_n() ? "wolf/wolf_tame" : (e.func_233678_J__() ? "wolf/wolf_angry" : "wolf/wolf")).mSingle(new ModelNewWolf())));
        H.addReplace("minecraft", "mooshroom", () -> () -> H.lambdaReplace(EntityType.field_200780_T, 1.2f, r -> r.preRender((e, s, p) -> {
            if (e.func_70631_g_()) {
                s.func_227862_a_(0.36f, 0.36f, 0.36f);
            }
        }).layer(LayerNewMooshroomMushroom::new).tCondition(e -> e.func_213444_dV() == MooshroomEntity.Type.RED, "mooshroom", "mooshroom_brown").mSingle(new ModelNewCow())));
        H.addReplace("minecraft", "squid", () -> () -> H.lambdaReplace(EntityType.field_200749_ao, 0.7f, r -> r.applyRotations((e, s, a, rot, p) -> {
            float f = e.field_70862_e + (e.field_70861_d - e.field_70862_e) * p;
            float f1 = e.field_70860_g + (e.field_70859_f - e.field_70860_g) * p;
            s.func_227861_a_(0.0, 0.5, 0.0);
            s.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rot));
            s.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f));
            s.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            s.func_227861_a_(0.0, (double)-1.2f, 0.0);
        }).handleRotation((e, p) -> -(e.field_70865_by + (e.field_70866_j - e.field_70865_by) * p)).tSingle("squid").mSingle(new ModelNewSquid())));
        H.addReplace("minecraft", "spider", () -> () -> H.lambdaReplace(EntityType.field_200748_an, 1.0f, r -> r.preRender((e, s, p) -> {
            if (e.func_70841_p()) {
                s.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                s.func_227861_a_(0.0, 0.75, -0.5);
            }
        }).layer(LayerNewSpiderEyes::new).tSingle("spider").mSingle(new ModelNewSpider())));
        H.addReplace("minecraft", "cavespider", () -> () -> H.lambdaReplace(EntityType.field_200794_h, 0.4f, r -> r.preRender((e, s, p) -> {
            if (e.func_70841_p()) {
                s.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                s.func_227861_a_(0.0, 0.75, -0.5);
            }
            s.func_227862_a_(0.5f, 0.5f, 0.5f);
        }).layer(LayerNewSpiderEyes::new).tSingle("cave_spider").mSingle(new ModelNewSpider())));
        H.addReplace("minecraft", "silverfish", () -> () -> H.lambdaReplace(EntityType.field_200740_af, 0.25f, r -> r.preRender((e, s, p) -> s.func_227862_a_(0.5f, 0.5f, 0.5f)).tSingle("silverfish").mSingle(new ModelNewSilverfish())));
        H.addReplace("minecraft", "polar_bear", () -> () -> H.lambdaReplace(EntityType.field_200786_Z, 1.0f, r -> r.childScale(0.7f).tSingle("polar_bear").mSingle(new ModelNewPolarBear())));
        H.addReplace("minecraft", "ocelot", () -> () -> H.lambdaReplace(EntityType.field_200781_U, 0.5f, r -> r.preRender((e, s, p) -> {
            s.func_227862_a_(0.8f, 0.8f, 0.8f);
            if (e.func_70631_g_()) {
                s.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
        }).tSingle("cat/ocelot").mSingle(new ModelNewCat())));
        Map catTextures = (Map)Util.func_200696_a((Object)Maps.newHashMap(), map -> {
            map.put(0, "cat/tabby");
            map.put(1, "cat/black");
            map.put(2, "cat/red");
            map.put(3, "cat/siamese");
            map.put(4, "cat/british_shorthair");
            map.put(5, "cat/calico");
            map.put(6, "cat/persian");
            map.put(7, "cat/ragdoll");
            map.put(8, "cat/white");
            map.put(9, "cat/jellie");
            map.put(10, "cat/all_black");
        });
        H.addReplace("minecraft", "cat", () -> () -> H.lambdaReplace(EntityType.field_220360_g, 0.5f, r -> r.preRender((e, s, p) -> {
            s.func_227862_a_(0.8f, 0.8f, 0.8f);
            if (e.func_70909_n()) {
                s.func_227862_a_(0.9f, 0.9f, 0.9f);
            }
            if (e.func_70631_g_()) {
                s.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
        }).layer(LayerNewCatCollar::new).tMapped(e -> (String)catTextures.get(e.func_213413_ef())).mSingle(new ModelNewCat())));
        H.addReplace("minecraft", "fox", () -> () -> H.lambdaReplace(EntityType.field_220356_B, 0.55f, r -> r.preRender((e, s, p) -> {
            if (e.func_70631_g_()) {
                s.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
            if (e.func_70608_bn()) {
                s.func_227861_a_(0.0, 0.5, 0.0);
            }
            if (e.func_213455_dW()) {
                s.func_227861_a_(0.0, (double)0.2f, 0.0);
            }
        }).applyRotations((e, s, a, rot, p) -> {
            if (e.func_213480_dY() || e.func_213472_dX()) {
                s.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-MathHelper.func_219799_g((float)p, (float)e.field_70127_C, (float)e.field_70125_A)));
            }
        }, ImplRenderer.SuperCallApplyRotations.PRE).layer(LayerNewFoxItem::new).tMapped(e -> e.func_213471_dV() == FoxEntity.Type.RED ? (e.func_70608_bn() ? "fox/fox_sleep" : "fox/fox") : (e.func_70608_bn() ? "fox/snow_fox_sleep" : "fox/snow_fox")).mSingle(new ModelNewFox())));
        H.addReplace("minecraft", "bee", () -> () -> H.lambdaReplace(EntityType.field_226289_e_, 0.4f, r -> r.childScale(0.5f).tMapped(e -> e.func_233678_J__() ? (e.func_226411_eD_() ? "bee/bee_angry_nectar" : "bee/bee_angry") : (e.func_226411_eD_() ? "bee/bee_nectar" : "bee/bee")).mSingle(new ModelNewBee())));
        H.addReplace("minecraft", "horse", () -> () -> H.lambdaReplace(EntityType.field_200762_B, 1.0f, r -> r.layer(LayerNewHorseMarking::new).layer(LayerNewHorseArmor::new).childScale(0.5f).tMappedRaw(e -> HORSE_VARIANTS.get(e.func_234239_eK_())).mSingle(new ModelNewHorse())));
        H.addReplace("minecraft", "zombie_horse", () -> () -> H.lambdaReplace(EntityType.field_200726_aE, 1.0f, r -> r.childScale(0.5f).tSingle("horse/horse_zombie").mSingle(new ModelNewHorse())));
        H.addReplace("minecraft", "skeleton_horse", () -> () -> H.lambdaReplace(EntityType.field_200742_ah, 1.0f, r -> r.ageScale(0.9f, 0.45f).tSingle("horse/horse_skeleton").mSingle(new ModelNewHorse())));
        H.addReplace("minecraft", "donkey", () -> () -> H.lambdaReplace(EntityType.field_200798_l, 1.0f, r -> r.ageScale(0.8f, 0.55f).tSingle("horse/donkey").mSingle(new ModelNewHorse())));
        H.addReplace("minecraft", "mule", () -> () -> H.lambdaReplace(EntityType.field_200779_S, 1.0f, r -> r.ageScale(0.85f, 0.55f).tSingle("horse/mule").mSingle(new ModelNewHorse())));
        Replacements.platformInit();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void platformInit() {
        ReplacementsImpl.platformInit();
    }
}

