/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.imdlib.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.itsmeow.betteranimalmodels.imdlib.block.GenericSkullBlock;
import dev.itsmeow.betteranimalmodels.imdlib.blockentity.HeadBlockEntity;
import dev.itsmeow.betteranimalmodels.imdlib.client.render.HeadModel;
import dev.itsmeow.betteranimalmodels.imdlib.util.HeadType;
import java.util.HashMap;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RenderGenericHead
extends TileEntityRenderer<HeadBlockEntity> {
    public static HashMap<HeadType, EntityModel<?>> modelMap = new HashMap();

    public RenderGenericHead(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(HeadBlockEntity te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState state = te.func_195044_w();
        if (!(state.func_177230_c() instanceof GenericSkullBlock)) {
            return;
        }
        Direction dir = te.getDirection();
        dir = dir == null ? Direction.NORTH : dir;
        float rotation = -dir.func_185119_l();
        rotation = dir == Direction.NORTH || dir == Direction.SOUTH ? dir.func_176734_d().func_185119_l() : rotation;
        rotation = dir == Direction.UP ? te.getTopRotation() : rotation;
        Object model = modelMap.get(te.getHeadType());
        if (model == null) {
            EntityModel<? extends Entity> newModel = te.getNewModel();
            modelMap.put(te.getHeadType(), newModel);
            model = newModel;
        }
        this.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, dir, rotation, te.getTexture(), (EntityModel<? extends Entity>)model);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, int packedOverlayIn, @Nullable Direction facing, float skullRotation, ResourceLocation texture, EntityModel<? extends Entity> model) {
        matrixStackIn.func_227860_a_();
        if (model instanceof HeadModel) {
            matrixStackIn.func_227861_a_(0.0, (double)(((HeadModel)model).globalOffsetY() * 0.0625f), 0.0);
        }
        if (facing == Direction.UP) {
            matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
        } else if (model instanceof HeadModel) {
            HeadModel m = (HeadModel)model;
            matrixStackIn.func_227861_a_((double)(0.5f - (float)facing.func_82601_c() * 0.25f - (float)facing.func_82601_c() * m.wallOffsetX() * 0.0625f), 0.25 + (double)(m.wallOffsetY() * 0.0625f), (double)(0.5f - (float)facing.func_82599_e() * 0.25f - (float)facing.func_82599_e() * m.wallOffsetZ() * 0.0625f));
        } else {
            matrixStackIn.func_227861_a_((double)(0.5f - (float)facing.func_82601_c() * 0.25f), 0.25, (double)(0.5f - (float)facing.func_82599_e() * 0.25f));
        }
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        float rotX = 0.0f;
        if (facing != null) {
            rotX = facing == Direction.UP ? -90.0f : 0.0f;
        }
        model.func_225597_a_(null, skullRotation, rotX, 0.0f, 0.0f, 0.0f);
        model.func_225598_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)texture)), packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }
}

