/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.imdlib.entity.util;

import com.google.common.collect.Lists;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.itsmeow.betteranimalmodels.imdlib.IMDLib;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.forge.BiomeTypesImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.architectury.registry.BiomeModifications;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class BiomeTypes {
    public static Type HOT;
    public static Type COLD;
    public static Type SPARSE;
    public static Type DENSE;
    public static Type WET;
    public static Type DRY;
    public static Type SAVANNA;
    public static Type CONIFEROUS;
    public static Type JUNGLE;
    public static Type SPOOKY;
    public static Type DEAD;
    public static Type LUSH;
    public static Type MUSHROOM;
    public static Type MAGICAL;
    public static Type RARE;
    public static Type PLATEAU;
    public static Type MODIFIED;
    public static Type OCEAN;
    public static Type RIVER;
    public static Type WATER;
    public static Type MESA;
    public static Type FOREST;
    public static Type PLAINS;
    public static Type MOUNTAIN;
    public static Type HILL;
    public static Type SWAMP;
    public static Type SANDY;
    public static Type SNOWY;
    public static Type WASTELAND;
    public static Type BEACH;
    public static Type VOID;
    public static Type OVERWORLD;
    public static Type NETHER;
    public static Type END;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        BiomeTypesImpl.init();
    }

    public static Set<Type> getTypes(BiomeModifications.BiomeContext ctx) {
        return Type.TYPES.stream().filter(t -> t.hasType(ctx)).collect(Collectors.toSet());
    }

    public static Set<Type> getTypes(RegistryKey<Biome> biome) {
        return Type.TYPES.stream().filter(t -> t.hasType(biome)).collect(Collectors.toSet());
    }

    public static Set<RegistryKey<Biome>> getBiomes(Type type) {
        MutableRegistry reg = null;
        try {
            reg = IMDLib.getStaticServerInstance().func_244267_aX().func_243612_b(Registry.field_239720_u_);
        }
        catch (RuntimeException e) {
            return new HashSet<RegistryKey<Biome>>();
        }
        Set<RegistryKey<Biome>> res = reg.func_201756_e().map(arg_0 -> ((MutableRegistry)reg).func_230519_c_(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(type::hasType).collect(Collectors.toSet());
        return res;
    }

    static {
        BiomeTypes.init();
    }

    public static class Type {
        protected static Set<Type> TYPES = new HashSet<Type>();
        private final Predicate<RegistryKey<Biome>> validator;
        private final Predicate<BiomeModifications.BiomeContext> ctxValidator;
        private final Map<RegistryKey<Biome>, Boolean> validations = new HashMap<RegistryKey<Biome>, Boolean>();
        private final Set<RegistryKey<Biome>> DEFAULTS = new HashSet<RegistryKey<Biome>>();

        public Type(Predicate<RegistryKey<Biome>> validator, Predicate<BiomeModifications.BiomeContext> ctxValidator) {
            this.validator = validator;
            this.ctxValidator = ctxValidator;
            TYPES.add(this);
        }

        public Type addDefaults(RegistryKey<Biome> ... biomes) {
            this.DEFAULTS.addAll(Lists.newArrayList((Object[])biomes));
            return this;
        }

        public boolean hasType(BiomeModifications.BiomeContext ctx) {
            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)ctx.getKey());
            if (this.DEFAULTS.contains(key)) {
                return true;
            }
            if (this.validations.containsKey(key)) {
                return this.validations.get(key);
            }
            boolean res = this.ctxValidator.test(ctx);
            this.validations.put((RegistryKey<Biome>)key, res);
            return res;
        }

        public boolean hasType(RegistryKey<Biome> biome) {
            if (this.DEFAULTS.contains(biome)) {
                return true;
            }
            if (this.validations.containsKey(biome)) {
                return this.validations.get(biome);
            }
            boolean res = this.validator.test(biome);
            this.validations.put(biome, res);
            return res;
        }
    }
}

