/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.imdlib.util.config;

import dev.itsmeow.betteranimalmodels.imdlib.util.config.CommonConfigAPI;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;

public abstract class ConfigBuilder {
    private Consumer<MinecraftServer> onLoadMethod;

    protected ConfigBuilder(CommonConfigAPI.ConfigType type, Consumer<ConfigBuilder> init, Runnable onLoad) {
        this.onLoadMethod = a -> onLoad.run();
    }

    protected ConfigBuilder(Consumer<ConfigBuilder> init, Consumer<MinecraftServer> onLoad) {
        this.onLoadMethod = onLoad;
    }

    public void onLoad(MinecraftServer t) {
        this.onLoadMethod.accept(t);
    }

    public abstract <T> Supplier<T> define(String var1, T var2);

    public abstract Supplier<Double> defineInRange(String var1, double var2, double var4, double var6);

    public abstract Supplier<Integer> defineInRange(String var1, int var2, int var3, int var4);

    public abstract Supplier<Long> defineInRange(String var1, long var2, long var4, long var6);

    public abstract <T> Supplier<List<? extends T>> defineList(String var1, List<? extends T> var2, T var3, Predicate<Object> var4);

    public abstract <T> Supplier<List<? extends T>> defineList(String var1, Supplier<List<? extends T>> var2, T var3, Predicate<Object> var4);

    public abstract <T> Supplier<T> define(String var1, String var2, T var3);

    public abstract Supplier<Double> defineInRange(String var1, String var2, double var3, double var5, double var7);

    public abstract Supplier<Integer> defineInRange(String var1, String var2, int var3, int var4, int var5);

    public abstract Supplier<Long> defineInRange(String var1, String var2, long var3, long var5, long var7);

    public abstract <T> Supplier<List<? extends T>> defineList(String var1, String var2, List<? extends T> var3, T var4, Predicate<Object> var5);

    public abstract <T> Supplier<List<? extends T>> defineList(String var1, String var2, Supplier<List<? extends T>> var3, T var4, Predicate<Object> var5);

    public abstract void push(String var1);

    public abstract void pop();
}

