/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.StringOpsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0010\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0014J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lkotlinx/serialization/json/internal/JsonStringBuilder;", "", "()V", "array", "", "([C)V", "size", "", "getSize", "()I", "setSize", "(I)V", "append", "", "ch", "", "value", "", "string", "", "appendQuoted", "appendStringSlowPath", "firstEscapedChar", "currentSize", "ensureAdditionalCapacity", "expected", "ensureTotalCapacity", "oldSize", "additional", "release", "toString", "kotlinx-serialization-json"})
public class JsonStringBuilder {
    @JvmField
    @NotNull
    protected char[] array;
    private int size;

    public JsonStringBuilder(@NotNull char[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        this.array = array;
    }

    public JsonStringBuilder() {
        this(CharArrayPool.INSTANCE.take());
    }

    protected final int getSize() {
        return this.size;
    }

    protected final void setSize(int n) {
        this.size = n;
    }

    public final void append(long value) {
        this.append(String.valueOf(value));
    }

    public final void append(char ch) {
        this.ensureAdditionalCapacity(1);
        int n = this.size;
        this.size = n + 1;
        this.array[n] = ch;
    }

    public final void append(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        int length = string.length();
        this.ensureAdditionalCapacity(length);
        String string2 = string;
        char[] cArray = this.array;
        int n = this.size;
        int n2 = 0;
        int n3 = string.length();
        string2.getChars(n2, n3, cArray, n);
        this.size += length;
    }

    public final void appendQuoted(@NotNull String string) {
        int sz;
        Intrinsics.checkNotNullParameter(string, "string");
        this.ensureAdditionalCapacity(string.length() + 2);
        char[] arr = this.array;
        int n = sz = this.size;
        sz = n + 1;
        arr[n] = 34;
        int length = string.length();
        String string2 = string;
        int n2 = 0;
        string2.getChars(n2, length, arr, sz);
        int n3 = sz;
        n2 = sz + length;
        while (n3 < n2) {
            int i;
            char ch;
            if ((ch = arr[i = n3++]) >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            this.appendStringSlowPath(i - sz, i, string);
            return;
        }
        n3 = sz += length;
        sz = n3 + 1;
        arr[n3] = 34;
        this.size = sz;
    }

    private final void appendStringSlowPath(int firstEscapedChar, int currentSize, String string) {
        int sz = currentSize;
        int n = firstEscapedChar;
        int n2 = string.length();
        while (n < n2) {
            int i = n++;
            sz = this.ensureTotalCapacity(sz, 2);
            char ch = string.charAt(i);
            if (ch < StringOpsKt.getESCAPE_MARKERS().length) {
                byte marker = StringOpsKt.getESCAPE_MARKERS()[ch];
                if (marker == 0) {
                    int n3 = sz;
                    sz = n3 + 1;
                    this.array[n3] = ch;
                    continue;
                }
                if (marker == 1) {
                    String escapedString;
                    Intrinsics.checkNotNull(StringOpsKt.getESCAPE_STRINGS()[ch]);
                    sz = this.ensureTotalCapacity(sz, escapedString.length());
                    String string2 = escapedString;
                    char[] cArray = this.array;
                    int n4 = 0;
                    int n5 = escapedString.length();
                    string2.getChars(n4, n5, cArray, sz);
                    this.size = sz += escapedString.length();
                    continue;
                }
                this.array[sz] = 92;
                this.array[sz + 1] = (char)marker;
                this.size = sz += 2;
                continue;
            }
            int n6 = sz;
            sz = n6 + 1;
            this.array[n6] = ch;
        }
        n = sz = this.ensureTotalCapacity(sz, 1);
        sz = n + 1;
        this.array[n] = 34;
        this.size = sz;
    }

    @NotNull
    public String toString() {
        return new String(this.array, 0, this.size);
    }

    private final void ensureAdditionalCapacity(int expected) {
        this.ensureTotalCapacity(this.size, expected);
    }

    protected int ensureTotalCapacity(int oldSize, int additional) {
        int newSize = oldSize + additional;
        if (this.array.length <= newSize) {
            char[] cArray = Arrays.copyOf(this.array, RangesKt.coerceAtLeast(newSize, oldSize * 2));
            Intrinsics.checkNotNullExpressionValue(cArray, "copyOf(this, newSize)");
            this.array = cArray;
        }
        return oldSize;
    }

    public void release() {
        CharArrayPool.INSTANCE.release(this.array);
    }
}

