/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.widget.OptionSlider;
import net.minecraft.client.gui.widget.SoundSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AdditionalVolumeSlider
extends AbstractClientTweak {
    private final SoundCategory soundCategory;
    private final int offsetX;

    public AdditionalVolumeSlider(String name, ForgeConfigSpec.BooleanValue configProperty, SoundCategory soundCategory, int offsetX) {
        super(name, configProperty);
        this.soundCategory = soundCategory;
        this.offsetX = offsetX;
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (this.isEnabled() && event.getGui() instanceof OptionsScreen) {
            int x = 0;
            int y = 0;
            for (Widget widget : event.getWidgetList()) {
                if (!(widget instanceof OptionSlider)) continue;
                x = widget.field_230690_l_;
                y = widget.field_230691_m_;
            }
            SoundSlider slider = new SoundSlider(Minecraft.func_71410_x(), x + this.offsetX, y + 27, this.soundCategory, 150);
            slider.func_238482_a_(this.getSliderDisplayString());
            event.addWidget((Widget)slider);
        }
    }

    private ITextComponent getSliderDisplayString() {
        float volume = Minecraft.func_71410_x().field_71474_y.func_186711_a(this.soundCategory);
        String displayVolume = volume == 0.0f ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : (int)(volume * 100.0f) + "%";
        TranslationTextComponent volumeText = new TranslationTextComponent("soundCategory." + this.soundCategory.func_187948_a());
        volumeText.func_230529_a_((ITextComponent)new StringTextComponent(": " + displayVolume));
        return volumeText;
    }
}

