/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Set;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.content.ContentListing;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.util.LogicHelper;

public class ContentIndex
extends ContentListing {
    public static final transient String ID = "index";
    private transient boolean loaded = false;
    private String[] hidden;
    private Operation[] operations;

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        if (!this.loaded) {
            this.loaded = true;
            ImmutableSet hiddenSet = this.hidden == null ? ImmutableSet.of((Object)"hidden") : ImmutableSet.builder().add((Object)"hidden").add((Object[])this.hidden).build();
            Operation[] operations = LogicHelper.defaultIfNull(this.operations, new Operation[0]);
            this.parent.parent.pages.forEach(arg_0 -> this.lambda$build$0((Set)hiddenSet, operations, arg_0));
        }
        super.build(book, list, rightSide);
    }

    private /* synthetic */ void lambda$build$0(Set hiddenSet, Operation[] operations, PageData page) {
        if (page != this.parent && !hiddenSet.contains(page.name)) {
            block10: for (Operation operation : operations) {
                if (!page.name.equals(operation.getBefore())) continue;
                switch (operation.getAction()) {
                    case "add_group": {
                        this.addEntry(operation.getData(), null, true);
                        continue block10;
                    }
                    case "column_break": {
                        this.addColumnBreak();
                        continue block10;
                    }
                    case "line_break": {
                        this.addEntry("", null, false);
                        continue block10;
                    }
                    default: {
                        Mantle.logger.error("Unknown ContentIndex action " + operation.getAction());
                    }
                }
            }
            this.addEntry(page.getTitle(), page, page.name.startsWith("group_"));
        }
    }

    protected static class Operation {
        private final String before;
        private final String action;
        private final String data;

        public Operation(String before, String action, String data) {
            this.before = before;
            this.action = action;
            this.data = data;
        }

        public String getBefore() {
            return this.before;
        }

        public String getAction() {
            return this.action;
        }

        public String getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Operation)) {
                return false;
            }
            Operation other = (Operation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$before = this.getBefore();
            String other$before = other.getBefore();
            if (this$before == null ? other$before != null : !this$before.equals(other$before)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Operation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $before = this.getBefore();
            result = result * 59 + ($before == null ? 43 : $before.hashCode());
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "ContentIndex.Operation(before=" + this.getBefore() + ", action=" + this.getAction() + ", data=" + this.getData() + ")";
        }
    }
}

