/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ListingLeftElement;

public class ContentListing
extends PageContent {
    public static final int LINE_HEIGHT = 10;
    public String title = null;
    public String subText = null;
    private final transient List<List<TextData>> entries = (List)Util.func_199748_a(() -> {
        ArrayList lists = new ArrayList(1);
        lists.add(new ArrayList());
        return lists;
    });

    public void addEntry(String text, @Nullable PageData link, boolean subSection) {
        TextData data = new TextData(text);
        data.bold = subSection;
        if (link != null) {
            data.action = "go-to-page-rtn:" + link.parent.name + "." + link.name;
        }
        this.entries.get(this.entries.size() - 1).add(data);
    }

    public void addEntry(String text, @Nullable PageData link) {
        this.addEntry(text, link, false);
    }

    public void addColumnBreak() {
        if (!this.entries.get(this.entries.size() - 1).isEmpty()) {
            if (this.entries.size() == 3) {
                Mantle.logger.warn("Too many columns in content listing, you should create a second listing instead");
            }
            this.entries.add(new ArrayList());
        }
    }

    public boolean hasEntries() {
        return this.entries.get(0).size() > 0;
    }

    private static int getColumnHeight(int yOff) {
        int columnHeight = BookScreen.PAGE_HEIGHT - yOff - 16;
        if (columnHeight % 10 != 0) {
            columnHeight -= columnHeight % 10;
        }
        return columnHeight;
    }

    public int getEntriesInColumn(SectionData sectionData) {
        int yOff = 0;
        if (this.title != null) {
            yOff = 16;
        }
        if (this.subText != null) {
            yOff += sectionData.parent.fontRenderer.func_78267_b(this.subText, BookScreen.PAGE_WIDTH) * 12 / 9;
        }
        return ContentListing.getColumnHeight(yOff) / 10;
    }

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int yOff = 0;
        if (this.title != null) {
            this.addTitle(list, this.title, false);
            yOff = 16;
        }
        if (this.subText != null) {
            int height = this.addText(list, this.subText, false, 0, yOff);
            yOff += height;
        }
        int columnHeight = ContentListing.getColumnHeight(yOff);
        int width = BookScreen.PAGE_WIDTH;
        int finalColumns = this.entries.size();
        int entriesPerColumn = columnHeight / 10;
        if (finalColumns < 3) {
            for (List<TextData> column : this.entries) {
                for (int totalEntries = column.size(); totalEntries > entriesPerColumn && ++finalColumns != 3; totalEntries -= entriesPerColumn) {
                }
            }
        }
        if (finalColumns > 3) {
            finalColumns = 3;
        }
        width /= finalColumns;
        int x = 0;
        int y = 0;
        for (List<TextData> column : this.entries) {
            for (TextData data : column) {
                String text;
                if (y >= columnHeight) {
                    x += width;
                    y = 0;
                }
                if ((text = data.text).isEmpty()) {
                    y += 10;
                    continue;
                }
                if (!data.bold) {
                    text = "- " + text;
                }
                int height = this.parent.parent.parent.fontRenderer.func_78267_b(text, width) * 10 / 9;
                list.add(new ListingLeftElement(x, y + yOff, width, height, data.bold, data));
                y += height;
            }
            x += width;
            y = 0;
        }
    }
}

