/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.transformer;

import javax.annotation.Nullable;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentListing;
import slimeknights.mantle.client.book.transformer.SectionTransformer;

public class ContentListingSectionTransformer
extends SectionTransformer {
    private final Boolean largeTitle;
    private final Boolean centerTitle;

    public ContentListingSectionTransformer(String sectionName, @Nullable Boolean largeTitle, @Nullable Boolean centerTitle) {
        super(sectionName);
        this.largeTitle = largeTitle;
        this.centerTitle = centerTitle;
    }

    public ContentListingSectionTransformer(String sectionName) {
        this(sectionName, null, null);
    }

    @Override
    public void transform(BookData book, SectionData data) {
        ContentListing listing = new ContentListing();
        listing.setLargeTitle(this.largeTitle);
        listing.setCenterTitle(this.centerTitle);
        listing.title = book.translate(this.sectionName);
        String subtextKey = this.sectionName + ".subtext";
        if (book.strings.containsKey(subtextKey)) {
            listing.subText = book.translate(subtextKey);
        }
        PageData listingPage = new PageData(true);
        listingPage.name = this.sectionName;
        listingPage.source = data.source;
        listingPage.parent = data;
        listingPage.content = listing;
        data.pages.removeIf(sectionPage -> !this.processPage(book, listing, (PageData)sectionPage));
        if (listing.hasEntries()) {
            listingPage.load();
            data.pages.add(0, listingPage);
        }
    }

    protected boolean processPage(BookData book, ContentListing listing, PageData page) {
        if (!page.name.equals("hidden")) {
            listing.addEntry(book.translate(page.getTitle()), page);
        }
        return true;
    }
}

