/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.util.JsonHelper;

public class BlockTagLootCondition
implements ILootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final ITag<Block> tag;
    private final StatePropertiesPredicate properties;

    public BlockTagLootCondition(ITag<Block> tag) {
        this(tag, StatePropertiesPredicate.field_227178_a_);
    }

    public BlockTagLootCondition(ITag<Block> tag, StatePropertiesPredicate.Builder builder) {
        this(tag, builder.func_227196_b_());
    }

    public boolean test(LootContext context) {
        BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        return state != null && state.func_235714_a_(this.tag) && this.properties.func_227181_a_(state);
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216287_g);
    }

    public LootConditionType func_230419_b_() {
        return MantleLoot.BLOCK_TAG_CONDITION;
    }

    public BlockTagLootCondition(ITag<Block> tag, StatePropertiesPredicate properties) {
        this.tag = tag;
        this.properties = properties;
    }

    private static class Serializer
    implements ILootSerializer<BlockTagLootCondition> {
        private Serializer() {
        }

        public void serialize(JsonObject json, BlockTagLootCondition loot, JsonSerializationContext context) {
            json.addProperty("tag", TagCollectionManager.func_242178_a().func_241835_a().func_232975_b_(loot.tag).toString());
            if (loot.properties != StatePropertiesPredicate.field_227178_a_) {
                json.add("properties", loot.properties.func_227180_a_());
            }
        }

        public BlockTagLootCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            ResourceLocation id = JsonHelper.getResourceLocation(json, "tag");
            ITag tag = TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(id);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown block tag '" + id + "'");
            }
            StatePropertiesPredicate predicate = StatePropertiesPredicate.field_227178_a_;
            if (json.has("properties")) {
                predicate = StatePropertiesPredicate.func_227186_a_((JsonElement)json.get("properties"));
            }
            return new BlockTagLootCondition((ITag<Block>)tag, predicate);
        }
    }
}

