/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ConsumerWrapperBuilder {
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    @Nullable
    private final IRecipeSerializer<?> override;
    @Nullable
    private final ResourceLocation overrideName;

    private ConsumerWrapperBuilder(@Nullable IRecipeSerializer<?> override, @Nullable ResourceLocation overrideName) {
        this.override = override;
        this.overrideName = overrideName;
    }

    public static ConsumerWrapperBuilder wrap() {
        return new ConsumerWrapperBuilder(null, null);
    }

    public static ConsumerWrapperBuilder wrap(IRecipeSerializer<?> override) {
        return new ConsumerWrapperBuilder(override, null);
    }

    public static ConsumerWrapperBuilder wrap(ResourceLocation override) {
        return new ConsumerWrapperBuilder(null, override);
    }

    public ConsumerWrapperBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public Consumer<IFinishedRecipe> build(Consumer<IFinishedRecipe> consumer) {
        return recipe -> consumer.accept(new Wrapped((IFinishedRecipe)recipe, this.conditions, (IRecipeSerializer)this.override, this.overrideName));
    }

    private static class Wrapped
    implements IFinishedRecipe {
        private final IFinishedRecipe original;
        private final List<ICondition> conditions;
        @Nullable
        private final IRecipeSerializer<?> override;
        @Nullable
        private final ResourceLocation overrideName;

        private Wrapped(IFinishedRecipe original, List<ICondition> conditions, @Nullable IRecipeSerializer<?> override, @Nullable ResourceLocation overrideName) {
            if (original instanceof Wrapped) {
                Wrapped toMerge = (Wrapped)original;
                this.original = toMerge.original;
                this.conditions = ImmutableList.builder().addAll(toMerge.conditions).addAll(conditions).build();
                if (toMerge.override != null || toMerge.overrideName != null) {
                    this.override = toMerge.override;
                    this.overrideName = toMerge.overrideName;
                } else {
                    this.override = override;
                    this.overrideName = overrideName;
                }
            } else {
                this.original = original;
                this.conditions = conditions;
                this.override = override;
                this.overrideName = overrideName;
            }
        }

        public JsonObject func_200441_a() {
            JsonObject json = new JsonObject();
            if (this.overrideName != null) {
                json.addProperty("type", this.overrideName.toString());
            } else {
                json.addProperty("type", Objects.requireNonNull(this.func_218609_c().getRegistryName()).toString());
            }
            this.func_218610_a(json);
            return json;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.conditions.isEmpty()) {
                JsonArray conditionsArray = new JsonArray();
                for (ICondition condition : this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                json.add("conditions", (JsonElement)conditionsArray);
            }
            this.original.func_218610_a(json);
        }

        public ResourceLocation func_200442_b() {
            return this.original.func_200442_b();
        }

        public IRecipeSerializer<?> func_218609_c() {
            if (this.override != null) {
                return this.override;
            }
            return this.original.func_218609_c();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.original.func_200440_c();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.original.func_200443_d();
        }
    }
}

