/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.CommandFunctions;
import com.natamus.collective.functions.NumberFunctions;
import com.natamus.collective.functions.RayTraceFunctions;
import com.natamus.collective.functions.WorldFunctions;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public class BlockPosFunctions {
    private static HashMap<BlockPos, Integer> rgnbcount = new HashMap();
    private static HashMap<BlockPos, Integer> rgnbmcount = new HashMap();

    public static List<BlockPos> getBlocksAround(BlockPos pos, boolean down) {
        ArrayList<BlockPos> around = new ArrayList<BlockPos>();
        around.add(pos.func_177978_c());
        around.add(pos.func_177974_f());
        around.add(pos.func_177968_d());
        around.add(pos.func_177976_e());
        around.add(pos.func_177984_a());
        if (down) {
            around.add(pos.func_177977_b());
        }
        return around;
    }

    public static List<BlockPos> getBlocksNextToEachOther(World world, BlockPos startpos, List<Block> possibleblocks) {
        return BlockPosFunctions.getBlocksNextToEachOther(world, startpos, possibleblocks, 50);
    }

    public static List<BlockPos> getBlocksNextToEachOther(World world, BlockPos startpos, List<Block> possibleblocks, int maxDistance) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (possibleblocks.contains(world.func_180495_p(startpos).func_177230_c())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        rgnbcount.put(startpos.func_185334_h(), 0);
        BlockPosFunctions.recursiveGetNextBlocks(world, startpos, startpos, possibleblocks, theblocksaround, checkedblocks, maxDistance);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocks(World world, BlockPos startpos, BlockPos pos, List<Block> possibleblocks, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks, int maxDistance) {
        int rgnbc = rgnbcount.get(startpos);
        if (rgnbc > 100) {
            return;
        }
        rgnbcount.put(startpos, rgnbc + 1);
        List<BlockPos> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (BlockPos pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possibleblocks.contains(world.func_180495_p(pba).func_177230_c()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            if (!BlockPosFunctions.withinDistance(startpos, pba, maxDistance).booleanValue()) continue;
            BlockPosFunctions.recursiveGetNextBlocks(world, startpos, pba, possibleblocks, theblocksaround, checkedblocks, maxDistance);
        }
    }

    public static List<BlockPos> getBlocksNextToEachOtherMaterial(World world, BlockPos startpos, List<Material> possiblematerials) {
        return BlockPosFunctions.getBlocksNextToEachOtherMaterial(world, startpos, possiblematerials, 50);
    }

    public static List<BlockPos> getBlocksNextToEachOtherMaterial(World world, BlockPos startpos, List<Material> possiblematerials, int maxDistance) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (possiblematerials.contains(world.func_180495_p(startpos).func_185904_a())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        rgnbmcount.put(startpos.func_185334_h(), 0);
        BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, startpos, possiblematerials, theblocksaround, checkedblocks, maxDistance);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocksMaterial(World world, BlockPos startpos, BlockPos pos, List<Material> possiblematerials, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks, int maxDistance) {
        int rgnbmc = rgnbmcount.get(startpos);
        if (rgnbmc > 100) {
            return;
        }
        rgnbmcount.put(startpos, rgnbmc + 1);
        List<BlockPos> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (BlockPos pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possiblematerials.contains(world.func_180495_p(pba).func_185904_a()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            if (!BlockPosFunctions.withinDistance(startpos, pba, maxDistance).booleanValue()) continue;
            BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, pba, possiblematerials, theblocksaround, checkedblocks, maxDistance);
        }
    }

    public static BlockPos getSurfaceBlockPos(ServerWorld serverworld, int x, int z) {
        int height = serverworld.func_234938_ad_();
        BlockPos returnpos = new BlockPos(x, height - 1, z);
        if (!WorldFunctions.isNether((World)serverworld)) {
            BlockPos pos = new BlockPos(x, height, z);
            for (int y = height; y > 0; --y) {
                BlockState blockstate = serverworld.func_180495_p(pos);
                Material material = blockstate.func_185904_a();
                if (blockstate.func_200016_a((IBlockReader)serverworld, pos) >= 15 || GlobalVariables.surfacematerials.contains(material)) {
                    returnpos = pos.func_177984_a().func_185334_h();
                    break;
                }
                pos = pos.func_177977_b();
            }
        } else {
            int maxheight = 128;
            BlockPos pos = new BlockPos(x, 0, z);
            for (int y = 0; y < maxheight; ++y) {
                BlockState upstate;
                BlockState blockstate = serverworld.func_180495_p(pos);
                if (blockstate.func_177230_c().equals(Blocks.field_150350_a) && (upstate = serverworld.func_180495_p(pos.func_177984_a())).func_177230_c().equals(Blocks.field_150350_a)) {
                    returnpos = pos.func_185334_h();
                    break;
                }
                pos = pos.func_177984_a();
            }
        }
        return returnpos;
    }

    public static BlockPos getCenterNearbyVillage(ServerWorld serverLevel) {
        return BlockPosFunctions.getNearbyVillage(serverLevel, new BlockPos(0, 0, 0));
    }

    public static BlockPos getNearbyVillage(ServerWorld serverLevel, BlockPos nearPos) {
        String rawcoords;
        String[] coords;
        BlockPos closestvillage = null;
        if (!serverLevel.func_73046_m().func_240793_aU_().func_230418_z_().func_236222_c_()) {
            return null;
        }
        String rawOutput = CommandFunctions.getRawCommandOutput(serverLevel, Vector3d.func_237492_c_((Vector3i)nearPos), "/locate village");
        if (rawOutput.contains("nearest") && rawOutput.contains("[") && (coords = (rawcoords = rawOutput.split("nearest")[1].split("\\[")[1].split("\\]")[0]).split(", ")).length == 3) {
            String sx = coords[0];
            String sz = coords[2];
            if (NumberFunctions.isNumeric(sx) && NumberFunctions.isNumeric(sz)) {
                return BlockPosFunctions.getSurfaceBlockPos(serverLevel, Integer.parseInt(sx), Integer.parseInt(sz));
            }
        }
        return closestvillage;
    }

    public static BlockPos getCenterNearbyBiome(ServerWorld serverLevel, String biome) {
        return BlockPosFunctions.getNearbyBiome(serverLevel, new BlockPos(0, 0, 0), biome);
    }

    public static BlockPos getNearbyBiome(ServerWorld serverLevel, BlockPos nearPos, String biome) {
        String rawcoords;
        String[] coords;
        String rawOutput = CommandFunctions.getRawCommandOutput(serverLevel, Vector3d.func_237492_c_((Vector3i)nearPos), "/locatebiome " + biome);
        if (rawOutput.contains("nearest") && rawOutput.contains("[") && (coords = (rawcoords = rawOutput.split("nearest")[1].split("\\[")[1].split("\\]")[0]).split(", ")).length == 3) {
            String sx = coords[0];
            String sz = coords[2];
            if (NumberFunctions.isNumeric(sx) && NumberFunctions.isNumeric(sz)) {
                return BlockPosFunctions.getSurfaceBlockPos(serverLevel, Integer.parseInt(sx), Integer.parseInt(sz));
            }
        }
        return null;
    }

    public static BlockPos getCenterNearbyStructure(ServerWorld serverworld, Structure<?> structure) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, new BlockPos(0, 0, 0));
    }

    public static BlockPos getNearbyStructure(ServerWorld serverworld, Structure<?> structure, BlockPos nearpos) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, nearpos, 9999);
    }

    public static BlockPos getNearbyStructure(ServerWorld serverworld, Structure<?> structure, BlockPos nearpos, int radius) {
        BlockPos villagepos = serverworld.func_241117_a_(structure, nearpos, radius, false);
        if (villagepos == null) {
            return null;
        }
        BlockPos spawnpos = null;
        for (int y = serverworld.func_234938_ad_() - 1; y > 0; --y) {
            BlockPos checkpos = new BlockPos(villagepos.func_177958_n(), y, villagepos.func_177952_p());
            if (serverworld.func_180495_p(checkpos).func_177230_c().equals(Blocks.field_150350_a)) continue;
            spawnpos = checkpos.func_177984_a().func_185334_h();
            break;
        }
        return spawnpos;
    }

    public static BlockPos getCenterBiome(ServerWorld serverworld, Biome biome) {
        BlockPos centerpos = new BlockPos(0, 0, 0);
        BlockPos biomepos = serverworld.func_241116_a_(biome, centerpos, 999999, 0);
        if (biomepos == null) {
            return null;
        }
        BlockPos spawnpos = null;
        for (int y = serverworld.func_234938_ad_() - 1; y > 0; --y) {
            BlockPos checkpos = new BlockPos(biomepos.func_177958_n(), y, biomepos.func_177952_p());
            if (serverworld.func_180495_p(checkpos).func_177230_c().equals(Blocks.field_150350_a)) continue;
            spawnpos = checkpos.func_177984_a().func_185334_h();
            break;
        }
        return spawnpos;
    }

    public static BlockPos getBlockPlayerIsLookingAt(World world, PlayerEntity player, boolean stopOnLiquid) {
        RayTraceResult raytraceresult = RayTraceFunctions.rayTrace(world, player, stopOnLiquid);
        double posX = raytraceresult.func_216347_e().field_72450_a;
        double posY = Math.floor(raytraceresult.func_216347_e().field_72448_b);
        double posZ = raytraceresult.func_216347_e().field_72449_c;
        return new BlockPos(posX, posY, posZ);
    }

    public static BlockPos getRandomCoordinatesInNearestUngeneratedChunk(ServerWorld serverLevel, BlockPos aroundPosition) {
        int outputRegionZ;
        int outputRegionX;
        ArrayList<String> regionList = new ArrayList<String>();
        try {
            File[] listOfRegionFiles;
            File regionFolder = new File(WorldFunctions.getWorldPath(serverLevel) + File.separator + "region");
            for (File regionFile : listOfRegionFiles = regionFolder.listFiles()) {
                if (!regionFile.isFile()) continue;
                regionList.add(regionFile.getName().replaceAll("r.", "").replaceAll(".mca", ""));
            }
        }
        catch (NullPointerException ignored) {
            return null;
        }
        ChunkPos chunkPos = serverLevel.func_175726_f(aroundPosition).func_76632_l();
        int curRegionX = chunkPos.func_222241_h();
        int curRegionZ = chunkPos.func_222242_i();
        int currentRange = 1;
        int loops = 0;
        String closestUngeneratedRegionString = "";
        while (closestUngeneratedRegionString.equals("")) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int regionX = curRegionX + x * currentRange;
                    int regionZ = curRegionZ + z * currentRange;
                    String regionString = regionX + "." + regionZ;
                    if (regionList.contains(regionString)) continue;
                    closestUngeneratedRegionString = regionString;
                    break;
                }
                if (!closestUngeneratedRegionString.equals("")) break;
            }
            ++currentRange;
            if (++loops <= 50) continue;
            return null;
        }
        String[] cursspl = closestUngeneratedRegionString.split("\\.");
        try {
            outputRegionX = Integer.parseInt(cursspl[0]);
            outputRegionZ = Integer.parseInt(cursspl[1]);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        int minXRange = outputRegionX * 512 - 256;
        int maxXRange = outputRegionX * 512 + 256;
        int minZRange = outputRegionZ * 512 - 256;
        int maxZRange = outputRegionZ * 512 + 256;
        int randomXCoord = ThreadLocalRandom.current().nextInt(minXRange, maxXRange + 1);
        int randomZCoord = ThreadLocalRandom.current().nextInt(minZRange, maxZRange + 1);
        int randomYCoord = BlockPosFunctions.getSurfaceBlockPos(serverLevel, randomXCoord, randomZCoord).func_177956_o();
        return new BlockPos(randomXCoord, randomYCoord, randomZCoord);
    }

    public static Boolean isOnSurface(World world, BlockPos pos) {
        return world.func_226660_f_(pos);
    }

    public static Boolean isOnSurface(World world, Vector3d vecpos) {
        return BlockPosFunctions.isOnSurface(world, new BlockPos(vecpos.field_72450_a, vecpos.field_72448_b, vecpos.field_72449_c));
    }

    public static Boolean withinDistance(BlockPos start, BlockPos end, int distance) {
        return BlockPosFunctions.withinDistance(start, end, (double)distance);
    }

    public static Boolean withinDistance(BlockPos start, BlockPos end, double distance) {
        return start.func_218141_a((Vector3i)end, distance);
    }
}

